/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.LesDTOs.ArticleAuteur;
import com.notrecontinent.webapi.LesDTOs.ArticleStatusDTO;
import com.notrecontinent.webapi.LesDTOs.ArticleWP;
import com.notrecontinent.webapi.LesDTOs.ArticlesAuteurDTO;
import com.notrecontinent.webapi.LesDTOs.ArticlesBrouillonAuteurDTO;
import com.notrecontinent.webapi.LesDTOs.ArticlesRejetesAuteurDTO;
import com.notrecontinent.webapi.LesDTOs.ArticlesValidationEnCoursAuteurDTO;
import com.notrecontinent.webapi.LesDTOs.ArticlesValidesAuteurDTO;
import com.notrecontinent.webapi.LesDTOs.MediaDTO;
import com.notrecontinent.webapi.LesDTOs.MediaWP;
import com.notrecontinent.webapi.config.UrlConfig;
import com.notrecontinent.webapi.dto.ArticleDto;
import com.notrecontinent.webapi.dto.ArticleWordpress;
import com.notrecontinent.webapi.entities.Article;
import com.notrecontinent.webapi.entities.ArticlePublierWordpress;
import com.notrecontinent.webapi.entities.ArticleWpCorbeille;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Categorie;
import com.notrecontinent.webapi.enumeration.SubdomainsPaysEnum;
import com.notrecontinent.webapi.mapstruct.ArticleMapper;
import com.notrecontinent.webapi.repositories.ArticlePublierWordpressRepository;
import com.notrecontinent.webapi.repositories.ArticleRepository;
import com.notrecontinent.webapi.repositories.ArticleWpCorbeilleRepository;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.CategorieRepository;
import com.notrecontinent.webapi.services.ArticleService;
import com.notrecontinent.webapi.services.BugsCronService;
import com.notrecontinent.webapi.services.EmojiUtilsService;
import com.notrecontinent.webapi.services.PhotoService;
import com.notrecontinent.webapi.services.PointsContributeurService;
import com.notrecontinent.webapi.services.SmsService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ArticleService {
    private final Path root = UrlConfig.root;
    private final Path root82 = UrlConfig.root82;
    private final String imagesPath = "/home/hostpeak/public_html/Uploads";
    private final String imagesPath82 = "/home/hostpeak/public_html/Uploads82";
    private final String dateFormat = "dd-MM-yyyy HH:mm:ss";
    @Autowired
    private ArticleRepository articleRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private PhotoService photoService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SmsService smsService;
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private PointsContributeurService pointsContributeurService;
    @Autowired
    private ArticlePublierWordpressRepository articlePublierWordpressRepository;
    @Autowired
    private ArticleMapper articleMapper;
    @Autowired
    private CategorieRepository categorieRepository;
    @Autowired
    private ArticleWpCorbeilleRepository articleWpCorbeilleRepository;
    @Autowired
    private EmojiUtilsService emojiUtilsService;
    private final String ImagesArticlespubliesPath = "/home/hostpeak/public_html/ImagesArticlespublies";
    private static final long MAX_FILE_SIZE = 0x4000000L;
    String userPassci = "Momar:Enpc kRrN iRmm scP5 rvzs Muul";
    String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    @Transactional
    public void SupprimerEmoji() {
        List articles = this.articleRepository.findAll();
        if (!articles.isEmpty()) {
            for (Article a : articles) {
                a.setTitre(this.emojiUtilsService.removeEmojis(a.getTitre()));
                a.setContenu(this.emojiUtilsService.removeEmojis(a.getContenu()));
                a.setTitre(this.emojiUtilsService.removeHtmlTags(a.getTitre()));
                a.setContenu(this.emojiUtilsService.removeHtmlTags(a.getContenu()));
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
    }

    @Transactional
    @Scheduled(cron="0 7 */3 * * *", zone="GMT")
    public void RecupererArticlesCorbeille() {
        int page = 1;
        int totalPages = 1;
        ArrayList<ArticleWordpress> articleWordpressList = new ArrayList<ArticleWordpress>();
        try {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes());
            headers.set("Authorization", authHeader);
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            do {
                String baseUrl;
                ResponseEntity response;
                if ((response = this.restTemplate.exchange(baseUrl = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=id,date_gmt,status,title,categories&status=trash&orderby=date&order=desc&per_page=100&page=" + page, HttpMethod.GET, requestEntity, ArticleWordpress[].class, new Object[0])).getBody() != null) {
                    for (ArticleWordpress a : (ArticleWordpress[])response.getBody()) {
                        articleWordpressList.add(a);
                    }
                }
                if (page != 1) continue;
                totalPages = Integer.parseInt(response.getHeaders().getFirst("X-WP-TotalPages"));
            } while (++page <= totalPages);
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de r\u00e9cup\u00e9ration des articles corbeille", e.getMessage());
        }
        if (!articleWordpressList.isEmpty()) {
            System.out.println(articleWordpressList.size());
            SimpleDateFormat wordpressDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            SimpleDateFormat desiredDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            ArrayList<ArticleWpCorbeille> articleWpCorbeilles = new ArrayList<ArticleWpCorbeille>();
            for (ArticleWordpress a : articleWordpressList) {
                if (this.articleWpCorbeilleRepository.existsByIdarticle(a.getId()).booleanValue()) continue;
                ArticleWpCorbeille articleWpCorbeille = new ArticleWpCorbeille();
                try {
                    Date date = wordpressDateFormat.parse(a.getDate_gmt());
                    String finaldatestring = desiredDateFormat.format(date);
                    articleWpCorbeille.setDate_gmt(desiredDateFormat.parse(finaldatestring));
                    articleWpCorbeille.setIdarticle(a.getId());
                    articleWpCorbeille.setEsttraiter(Boolean.valueOf(false));
                    articleWpCorbeilles.add(articleWpCorbeille);
                    System.out.println(articleWpCorbeilles.size());
                }
                catch (Exception e) {
                    System.out.println("----------------------------------------------------");
                    System.out.println("Message du bug");
                    System.out.println(e.getMessage());
                    System.out.println("----------------------------------------------------");
                    this.bugsCronService.SaveBugCron("Cron de r\u00e9cup\u00e9ration de l'article corbeille (idWP: " + a.getId() + ")", e.getMessage());
                }
            }
            System.out.println("---- " + articleWpCorbeilles.size());
            if (!articleWpCorbeilles.isEmpty()) {
                System.out.println("---->> " + articleWpCorbeilles.size());
                this.articleWpCorbeilleRepository.saveAll(articleWpCorbeilles);
                articleWpCorbeilles = null;
                articleWordpressList = null;
            }
        }
    }

    @Transactional
    @Scheduled(cron="0 13 */3 * * *", zone="GMT")
    public void MAJArticlesRejetes() {
        List articleWpCorbeilles = this.articleWpCorbeilleRepository.findByEsttraiter(Boolean.valueOf(false));
        if (!articleWpCorbeilles.isEmpty()) {
            HashSet<Long> ids = new HashSet<Long>();
            for (ArticleWpCorbeille a : articleWpCorbeilles) {
                ids.add(a.getIdarticle());
            }
            ArrayList idds = new ArrayList(ids);
            List articles = this.articleRepository.findByWordpressIDIn(idds);
            if (!articles.isEmpty()) {
                for (Article article : articles) {
                    if (!article.getStatus().equals("Rejet\u00e9")) {
                        article.setLastStatus(article.getStatus());
                    }
                    article.setStatus("Rejet\u00e9");
                }
                this.articleRepository.saveAll((Iterable)articles);
            }
            for (ArticleWpCorbeille articleWpCorbeille : articleWpCorbeilles) {
                articleWpCorbeille.setEsttraiter(Boolean.valueOf(true));
            }
            this.articleWpCorbeilleRepository.saveAll((Iterable)articleWpCorbeilles);
        }
    }

    @Transactional
    @Scheduled(cron="0 19 */3 * * *", zone="GMT")
    public void MAJStatusArticles() {
        int page = 1;
        int totalPages = 1;
        ArrayList<ArticleWordpress> articleWordpressList = new ArrayList<ArticleWordpress>();
        try {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes());
            headers.set("Authorization", authHeader);
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            do {
                String baseUrl;
                ResponseEntity response;
                if ((response = this.restTemplate.exchange(baseUrl = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=id,status&status=future,pending&orderby=date&order=desc&per_page=100&page=" + page, HttpMethod.GET, requestEntity, ArticleWordpress[].class, new Object[0])).getBody() != null) {
                    for (ArticleWordpress a : (ArticleWordpress[])response.getBody()) {
                        articleWordpressList.add(a);
                    }
                }
                if (page != 1) continue;
                totalPages = Integer.parseInt(response.getHeaders().getFirst("X-WP-TotalPages"));
                System.out.println("total pages articles planifi\u00e9s et en attente de relecture : " + totalPages);
            } while (++page <= totalPages);
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de r\u00e9cup\u00e9ration des articles planifi\u00e9s et en attente de relecture", e.getMessage());
        }
        System.out.println("total articles planifi\u00e9s et en attente de relecture : " + articleWordpressList.size());
        page = 1;
        totalPages = 1;
        LocalDateTime currentdate = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime currentdatemoins24heures = currentdate.minusHours(24L);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        String currentdatemoins24heurestring = currentdatemoins24heures.format(dateTimeFormatter);
        System.out.println("date actuelle moins 24 heures : " + currentdatemoins24heurestring);
        try {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes());
            headers.set("Authorization", authHeader);
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            do {
                String baseUrl;
                ResponseEntity response;
                if ((response = this.restTemplate.exchange(baseUrl = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=id,status,date_gmt,link&status=publish&after=" + currentdatemoins24heurestring + "&per_page=100&page=" + page, HttpMethod.GET, requestEntity, ArticleWordpress[].class, new Object[0])).getBody() != null) {
                    for (ArticleWordpress a : (ArticleWordpress[])response.getBody()) {
                        articleWordpressList.add(a);
                    }
                }
                if (page != 1) continue;
                totalPages = Integer.parseInt(response.getHeaders().getFirst("X-WP-TotalPages"));
                System.out.println("total pages articles publi\u00e9s depuis 24 heures : " + totalPages);
            } while (++page <= totalPages);
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de r\u00e9cup\u00e9ration des articles publi\u00e9s depuis 24h", e.getMessage());
        }
        System.out.println("total articles planifi\u00e9s, en attente de relecture et publi\u00e9s (depuis 24h) : " + articleWordpressList.size());
        if (!articleWordpressList.isEmpty()) {
            SimpleDateFormat wordpressDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            SimpleDateFormat desiredDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            HashSet<Long> idsarticles = new HashSet<Long>();
            for (ArticleWordpress articleWordpress : articleWordpressList) {
                idsarticles.add(articleWordpress.getId());
            }
            ArrayList ids = new ArrayList(idsarticles);
            List articleList = this.articleRepository.findByWordpressIDIn(ids);
            if (!articleList.isEmpty()) {
                System.out.println("d\u00e9but de la comparaison");
                block11: for (int i = 0; i < articleList.size(); ++i) {
                    for (int j = 0; j < articleWordpressList.size(); ++j) {
                        if (!Objects.equals(((Article)articleList.get(i)).getWordpressID(), ((ArticleWordpress)articleWordpressList.get(j)).getId())) continue;
                        System.out.println("correspondance");
                        if (((ArticleWordpress)articleWordpressList.get(j)).getStatus().equals("future")) {
                            if (!((Article)articleList.get(i)).getStatus().equals("Planifi\u00e9")) {
                                ((Article)articleList.get(i)).setLastStatus(((Article)articleList.get(i)).getStatus());
                            }
                            ((Article)articleList.get(i)).setStatus("Planifi\u00e9");
                            continue block11;
                        }
                        if (((ArticleWordpress)articleWordpressList.get(j)).getStatus().equals("pending")) {
                            if (!((Article)articleList.get(i)).getStatus().equals("Validation en cours")) {
                                ((Article)articleList.get(i)).setLastStatus(((Article)articleList.get(i)).getStatus());
                            }
                            ((Article)articleList.get(i)).setStatus("Validation en cours");
                            continue block11;
                        }
                        if (!((ArticleWordpress)articleWordpressList.get(j)).getStatus().equals("publish")) continue block11;
                        try {
                            Auteur auteur1;
                            if (!((Article)articleList.get(i)).getStatus().equals("Valid\u00e9 (en ligne)")) {
                                ((Article)articleList.get(i)).setLastStatus(((Article)articleList.get(i)).getStatus());
                            }
                            ((Article)articleList.get(i)).setStatus("Valid\u00e9 (en ligne)");
                            if (((Article)articleList.get(i)).getLink() != null) continue block11;
                            ((Article)articleList.get(i)).setLink(((ArticleWordpress)articleWordpressList.get(j)).getLink());
                            Date date = wordpressDateFormat.parse(((ArticleWordpress)articleWordpressList.get(j)).getDate_gmt());
                            String finaldatestring = desiredDateFormat.format(date);
                            ((Article)articleList.get(i)).setDatepublication(desiredDateFormat.parse(finaldatestring));
                            Optional auteur = this.auteurRepository.findById((Object)((Article)articleList.get(i)).getAuteurID());
                            if (!auteur.isPresent() || (auteur1 = (Auteur)auteur.get()).getMonetisation() == null || !auteur1.getMonetisation().equals("Oui")) continue block11;
                            this.pointsContributeurService.VerifAndAddPointContributeur(((Article)articleList.get(i)).getLink(), ((Article)articleList.get(i)).getTitre(), ((Article)articleList.get(i)).getAuteurID(), ((Article)articleList.get(i)).getStatus());
                            List pointsContributeurList = this.pointsContributeurService.getAllByContributeurid(auteur1.getId());
                            if (pointsContributeurList.isEmpty()) continue block11;
                            Long total = 100L * (long)pointsContributeurList.size();
                            auteur1.setTotalPointsCumules(total);
                            this.auteurRepository.save((Object)auteur1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("----------------------------------------------------");
                            System.out.println("Message du bug");
                            System.out.println(e.getMessage());
                            System.out.println("----------------------------------------------------");
                            this.bugsCronService.SaveBugCron("parsing de la date de l'article worpdressid : " + ((ArticleWordpress)articleWordpressList.get(j)).getId(), e.getMessage());
                        }
                        continue block11;
                    }
                }
                System.out.println("fin de la comparaison");
            }
            this.articleRepository.saveAll((Iterable)articleList);
        }
    }

    @Transactional
    public void VerifValidation() {
        try {
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add("Validation en cours");
            statusList.add("Valid\u00e9 (en ligne)");
            statusList.add("Rejet\u00e9");
            List articles = this.articleRepository.findByStatusInAndAdesactiverAndAreactiver(statusList, Boolean.valueOf(false), Boolean.valueOf(false));
            SimpleDateFormat wordpressDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            SimpleDateFormat desiredDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            for (int i = 0; i < articles.size(); ++i) {
                Long id = ((Article)articles.get(i)).getWordpressID();
                HttpHeaders headers = new HttpHeaders();
                String authHeader = "";
                authHeader = ((Article)articles.get(i)).getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                headers.set("Authorization", authHeader);
                HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
                try {
                    ResponseEntity response = this.restTemplate.exchange(((Article)articles.get(i)).getSousdomaine() + "/wp-json/wp/v2/posts/" + id + "?_fields=status,title,link,date_gmt", HttpMethod.GET, requestEntity, ArticleWordpress.class, new Object[0]);
                    ArticleWordpress articleWordpress = (ArticleWordpress)response.getBody();
                    if (articleWordpress == null) continue;
                    if (articleWordpress.getStatus().equals("publish")) {
                        Auteur auteur1;
                        if (!((Article)articles.get(i)).getStatus().equals("Valid\u00e9 (en ligne)")) {
                            ((Article)articles.get(i)).setLastStatus(((Article)articles.get(i)).getStatus());
                        }
                        if (!((Article)articles.get(i)).getStatus().equals("Validation en cours")) continue;
                        ((Article)articles.get(i)).setStatus("Valid\u00e9 (en ligne)");
                        ((Article)articles.get(i)).setLink(articleWordpress.getLink());
                        ((Article)articles.get(i)).setDatepublication(new Date());
                        ((Article)articles.get(i)).setTitre(articleWordpress.getTitle().getRendered().replace("&rsquo;", "'").replace("&#8211;", "-"));
                        Optional auteur = this.auteurRepository.findById((Object)((Article)articles.get(i)).getAuteurID());
                        if (auteur.isPresent() && (auteur1 = (Auteur)auteur.get()).getMonetisation() != null && auteur1.getMonetisation().equals("Oui")) {
                            this.pointsContributeurService.VerifAndAddPointContributeur(((Article)articles.get(i)).getLink(), ((Article)articles.get(i)).getTitre(), ((Article)articles.get(i)).getAuteurID(), ((Article)articles.get(i)).getStatus());
                            List pointsContributeurList = this.pointsContributeurService.getAllByContributeurid(auteur1.getId());
                            if (!pointsContributeurList.isEmpty()) {
                                Long total = 100L * (long)pointsContributeurList.size();
                                auteur1.setTotalPointsCumules(total);
                                this.auteurRepository.save((Object)auteur1);
                            }
                        }
                        if (!((Article)articles.get(i)).getSmsenvoyer().booleanValue() && !((Article)articles.get(i)).getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain())) continue;
                    }
                    if (articleWordpress.getStatus().equals("trash") && !((Article)articles.get(i)).getStatus().equals("Rejet\u00e9")) {
                        ((Article)articles.get(i)).setLastStatus(((Article)articles.get(i)).getStatus());
                        ((Article)articles.get(i)).setStatus("Rejet\u00e9");
                        continue;
                    }
                    if (articleWordpress.getStatus().equals("draft") && !((Article)articles.get(i)).getStatus().equals("Validation en cours")) {
                        ((Article)articles.get(i)).setLastStatus(((Article)articles.get(i)).getStatus());
                        ((Article)articles.get(i)).setStatus("Validation en cours");
                        continue;
                    }
                    if (!articleWordpress.getStatus().equals("pending") || ((Article)articles.get(i)).getStatus().equals("Validation en cours")) continue;
                    ((Article)articles.get(i)).setLastStatus(((Article)articles.get(i)).getStatus());
                    ((Article)articles.get(i)).setStatus("Validation en cours");
                    continue;
                }
                catch (Exception e) {
                    System.out.println("----------------------------------------------------");
                    System.out.println("Message du bug");
                    System.out.println(e.getMessage());
                    System.out.println("----------------------------------------------------");
                    this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour du status de l'article" + ((Article)articles.get(i)).getTitre() + "(id: " + ((Article)articles.get(i)).getId() + ")", e.getMessage());
                }
            }
            this.articleRepository.saveAll((Iterable)articles);
            Object var2_3 = null;
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour du status des articles", e.getMessage());
        }
    }

    @Transactional
    public void VerifValidation2() {
        this.VerifValidation();
    }

    @Transactional
    public void VerifValidation3() {
        this.VerifValidation();
    }

    @Scheduled(cron="20 11 */3 * * *", zone="GMT")
    @Transactional
    public void PublierArticles() {
        try {
            List articles = this.articleRepository.findByStatusAndWordpressIDIsNull("Validation en cours");
            if (!articles.isEmpty()) {
                HttpHeaders headers = new HttpHeaders();
                String authHeader = "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes());
                headers.set("Authorization", authHeader);
                List categories = this.categorieRepository.findAll();
                for (Article article : articles) {
                    try {
                        File videoToUpload;
                        String string;
                        HttpEntity articleRequestEntityUpdate;
                        ResponseEntity responseEntity;
                        HttpEntity imageEntity;
                        headers = new HttpHeaders();
                        authHeader = article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                        headers.set("Authorization", authHeader);
                        ArticleWP articleWP = new ArticleWP();
                        articleWP.setStatus("pending");
                        String footerarticle = "\n\n\n";
                        if (article.getPseudoauteur() != null && !article.getPseudoauteur().equals("")) {
                            footerarticle = footerarticle + "\nPseudonyme du contributeur : " + article.getPseudoauteur();
                        }
                        if (article.getAnonymat().equals("Non") || article.getAnonymat().equals("Oui")) {
                            footerarticle = footerarticle + "\nAfficher le nom du contributeur : " + article.getAnonymat();
                        }
                        if (article.getLienyoutube() != null && !article.getLienyoutube().equals("")) {
                            footerarticle = footerarticle + "\nLien Youtube : " + article.getLienyoutube();
                        }
                        articleWP.setContent(article.getContenu() + footerarticle);
                        articleWP.setTitle(article.getTitre());
                        Auteur auteur = (Auteur)this.auteurRepository.findById((Object)article.getAuteurID()).get();
                        if (article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain())) {
                            articleWP.setAuthor(auteur.getWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.CA.getSubdomain())) {
                            articleWP.setAuthor(auteur.getCaWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.BJ.getSubdomain())) {
                            articleWP.setAuthor(auteur.getBjWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.BF.getSubdomain())) {
                            articleWP.setAuthor(auteur.getBfWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.CG.getSubdomain())) {
                            articleWP.setAuthor(auteur.getCgWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.CD.getSubdomain())) {
                            articleWP.setAuthor(auteur.getCdWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.CI.getSubdomain())) {
                            articleWP.setAuthor(auteur.getCiWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.CM.getSubdomain())) {
                            articleWP.setAuthor(auteur.getCmWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.FR.getSubdomain())) {
                            articleWP.setAuthor(auteur.getFrWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.GA.getSubdomain())) {
                            articleWP.setAuthor(auteur.getGaWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.GN.getSubdomain())) {
                            articleWP.setAuthor(auteur.getGnWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.MG.getSubdomain())) {
                            articleWP.setAuthor(auteur.getMgWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.ML.getSubdomain())) {
                            articleWP.setAuthor(auteur.getMlWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.MR.getSubdomain())) {
                            articleWP.setAuthor(auteur.getMrWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.NE.getSubdomain())) {
                            articleWP.setAuthor(auteur.getNeWordpressID());
                        } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.TG.getSubdomain())) {
                            articleWP.setAuthor(auteur.getTgWordpressID());
                        }
                        for (Categorie categorie : categories) {
                            if (!categorie.getName().equals(article.getCategorie())) continue;
                            articleWP.setCategories(categorie.getId());
                            break;
                        }
                        HttpEntity articleRequestEntity = new HttpEntity((Object)articleWP, (MultiValueMap)headers);
                        String response = (String)this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/posts", HttpMethod.POST, articleRequestEntity, String.class, new Object[0]).getBody();
                        Long id = Long.valueOf(response.split(",")[0].split(":")[1]);
                        HttpHeaders headersfiles = new HttpHeaders();
                        headersfiles.set("Authorization", authHeader);
                        headersfiles.setContentType(MediaType.MULTIPART_FORM_DATA);
                        String newFileName = article.getTitre() + ".jpeg";
                        LinkedMultiValueMap body = new LinkedMultiValueMap();
                        if (article.getImage() != null) {
                            File fileToUpload = new File("/home/hostpeak/public_html/Uploads/" + article.getImage());
                            1 fileSystemResource = new /* Unavailable Anonymous Inner Class!! */;
                            body.add((Object)"file", (Object)fileSystemResource);
                            body.add((Object)"post", (Object)id);
                            imageEntity = new HttpEntity((Object)body, (MultiValueMap)headersfiles);
                            responseEntity = this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/media", HttpMethod.POST, imageEntity, MediaDTO.class, new Object[0]);
                            Long idimage = ((MediaDTO)responseEntity.getBody()).getId();
                            articleWP.setFeatured_media(idimage);
                            articleRequestEntityUpdate = new HttpEntity((Object)articleWP, (MultiValueMap)headers);
                            string = (String)this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/posts/" + id, HttpMethod.PUT, articleRequestEntityUpdate, String.class, new Object[0]).getBody();
                        }
                        if (article.getAutresImages() != null) {
                            1 nomsImages;
                            for (1 file : nomsImages = article.getAutresImages().split("/")) {
                                File imageToUpload = new File("/home/hostpeak/public_html/Uploads/" + (String)file);
                                2 fileSystemResource1 = new /* Unavailable Anonymous Inner Class!! */;
                                body = new LinkedMultiValueMap();
                                body.add((Object)"file", (Object)fileSystemResource1);
                                body.add((Object)"post", (Object)id);
                                HttpEntity imageEntity2 = new HttpEntity((Object)body, (MultiValueMap)headersfiles);
                                ResponseEntity responseEntity2 = this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/media", HttpMethod.POST, imageEntity2, String.class, new Object[0]);
                            }
                        }
                        if (article.getVideo() != null && (videoToUpload = new File("/home/hostpeak/public_html/Uploads/" + article.getVideo())).exists() && videoToUpload.length() < 0x4000000L) {
                            3 fileSystemResourcevideo = new /* Unavailable Anonymous Inner Class!! */;
                            body = new LinkedMultiValueMap();
                            body.add((Object)"file", (Object)fileSystemResourcevideo);
                            body.add((Object)"post", (Object)id);
                            imageEntity = new HttpEntity((Object)body, (MultiValueMap)headersfiles);
                            responseEntity = this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/media", HttpMethod.POST, imageEntity, MediaDTO.class, new Object[0]);
                            String lienvideo = ((MediaDTO)responseEntity.getBody()).getGuid().getRendered();
                            articleWP.setContent(lienvideo + "\n\n" + articleWP.getContent());
                            articleRequestEntityUpdate = new HttpEntity((Object)articleWP, (MultiValueMap)headers);
                            string = (String)this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/posts/" + id, HttpMethod.PUT, articleRequestEntityUpdate, String.class, new Object[0]).getBody();
                        }
                        article.setWordpressID(id);
                        article.setSmsenvoyer(Boolean.valueOf(false));
                    }
                    catch (Exception e) {
                        System.out.println("----------------------------------------------------");
                        System.out.println("Message du bug");
                        System.out.println(e.getMessage());
                        System.out.println("----------------------------------------------------");
                        this.bugsCronService.SaveBugCron("Cron de publication de l'article identifi\u00e9 " + article.getId() + " vers Wordpress", e.getMessage());
                    }
                }
                this.articleRepository.saveAllAndFlush((Iterable)articles);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de publication des articles vers Wordpress", e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void getArticlesPubliesderniereheure() throws ParseException {
        LocalDateTime currentdate = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime currentdatemoins1heure = currentdate.minusHours(1L);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        String currentdatemoins1heurestring = currentdatemoins1heure.format(dateTimeFormatter);
        String baseUrl = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=id,date,status,title,link,categories,featured_media&status=publish&orderby=date&order=desc&after=" + currentdatemoins1heurestring + "&per_page=100";
        ResponseEntity response = this.restTemplate.exchange(baseUrl, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]);
        List<Object> articleWordpressList = Arrays.asList((Object[])response.getBody());
        if (!articleWordpressList.isEmpty() && !(articleWordpressList = articleWordpressList.stream().filter(a -> this.articlePublierWordpressRepository.existsByIdarticle(a.getId()) == false).collect(Collectors.toList())).isEmpty()) {
            void var12_14;
            SimpleDateFormat wordpressDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            SimpleDateFormat desiredDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            ArrayList<ArticlePublierWordpress> articlePublierWordpresses = new ArrayList<ArticlePublierWordpress>();
            for (ArticleWordpress articleWordpress : articleWordpressList) {
                ArticlePublierWordpress a2 = new ArticlePublierWordpress();
                a2.setIdarticle(articleWordpress.getId());
                a2.setLink(articleWordpress.getLink());
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                titre = titre.replace("&#8230;", "...").replace("&#8211;", "-");
                titre = titre.replace("&#8217;", "'");
                a2.setTitle(titre);
                a2.setImageid(articleWordpress.getFeatured_media());
                Date date = wordpressDateFormat.parse(articleWordpress.getDate());
                String finaldatestring = desiredDateFormat.format(date);
                a2.setDate(desiredDateFormat.parse(finaldatestring));
                Long categorieID = articleWordpress.getCategories()[0];
                a2.setCategorie(((Categorie)this.categorieRepository.findById((Object)categorieID).get()).getName());
                articlePublierWordpresses.add(a2);
            }
            String baseWPimagesUrl = "https://sn.notrecontinent.com/wp-json/wp/v2/media?_fields=id,guid&per_page=100";
            String string = "";
            for (int i = 0; i < articlePublierWordpresses.size(); ++i) {
                if (i == articlePublierWordpresses.size() - 1) {
                    String string2 = (String)var12_14 + ((ArticlePublierWordpress)articlePublierWordpresses.get(i)).getImageid();
                    continue;
                }
                String string3 = (String)var12_14 + ((ArticlePublierWordpress)articlePublierWordpresses.get(i)).getImageid() + ",";
            }
            ResponseEntity resp = this.restTemplate.exchange(baseWPimagesUrl + "&include=" + (String)var12_14, HttpMethod.GET, null, MediaWP[].class, new Object[0]);
            List<Object> mediaWPList = Arrays.asList((Object[])resp.getBody());
            block4: for (ArticlePublierWordpress articlePublierWordpress : articlePublierWordpresses) {
                for (MediaWP mediaWP : mediaWPList) {
                    if (!Objects.equals(articlePublierWordpress.getImageid(), mediaWP.getId())) continue;
                    String imageurl = mediaWP.getGuid().getRendered();
                    String imageurl350x196 = imageurl.substring(0, imageurl.length() - 4) + "-350x196.jpg";
                    articlePublierWordpress.setImageUrl(imageurl350x196);
                    String[] tableau = imageurl350x196.split("/");
                    String imagesArticlespubliesPath = "/home/hostpeak/public_html/ImagesArticlespublies/" + tableau[tableau.length - 1];
                    ResponseEntity Imageresponse = this.restTemplate.getForEntity(imageurl350x196, byte[].class, new Object[0]);
                    if (response.getStatusCode().is2xxSuccessful()) {
                        try {
                            FileOutputStream fos = new FileOutputStream(imagesArticlespubliesPath);
                            fos.write((byte[])Imageresponse.getBody());
                            fos.close();
                            articlePublierWordpress.setImagelocal(tableau[tableau.length - 1]);
                            System.out.println("L'image a \u00e9t\u00e9 t\u00e9l\u00e9charg\u00e9e avec succ\u00e8s dans " + imagesArticlespubliesPath);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue block4;
                    }
                    System.err.println("\u00c9chec du t\u00e9l\u00e9chargement de l'image depuis WordPress. Code de statut : " + response.getStatusCodeValue());
                    continue block4;
                }
            }
            this.articlePublierWordpressRepository.saveAll(articlePublierWordpresses);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void getArticlesPublies2derniersmois() throws ParseException {
        String baseUrl = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=id,date,status,title,link,categories,featured_media&status=publish&orderby=date&order=desc&after=2024-02-04T00:00:00&per_page=100";
        ResponseEntity response = this.restTemplate.exchange(baseUrl, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]);
        HttpHeaders headers = response.getHeaders();
        List headerNbPages = headers.get((Object)"X-WP-TotalPages");
        if (headerNbPages != null && !headerNbPages.isEmpty()) {
            Long nbTotalPages = Long.valueOf((String)headerNbPages.get(0));
            ArrayList<Object> articleWordpressList = new ArrayList<Object>();
            int i = 1;
            while ((long)i <= nbTotalPages) {
                ResponseEntity resp = this.restTemplate.exchange(baseUrl + "&page=" + i, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]);
                articleWordpressList.addAll(Arrays.asList((Object[])resp.getBody()));
                ++i;
            }
            if (!articleWordpressList.isEmpty()) {
                void var11_14;
                SimpleDateFormat wordpressDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                SimpleDateFormat desiredDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ArrayList<ArticlePublierWordpress> articlePublierWordpresses = new ArrayList<ArticlePublierWordpress>();
                for (ArticleWordpress articleWordpress : articleWordpressList) {
                    ArticlePublierWordpress a = new ArticlePublierWordpress();
                    a.setIdarticle(articleWordpress.getId());
                    a.setLink(articleWordpress.getLink());
                    String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                    titre = titre.replace("&#8230;", "...").replace("&#8211;", "-");
                    titre = titre.replace("&#8217;", "'");
                    a.setTitle(titre);
                    a.setImageid(articleWordpress.getFeatured_media());
                    Date date = wordpressDateFormat.parse(articleWordpress.getDate());
                    String finaldatestring = desiredDateFormat.format(date);
                    a.setDate(desiredDateFormat.parse(finaldatestring));
                    Long categorieID = articleWordpress.getCategories()[0];
                    a.setCategorie(((Categorie)this.categorieRepository.findById((Object)categorieID).get()).getName());
                    articlePublierWordpresses.add(a);
                }
                String baseWPimagesUrl = "https://sn.notrecontinent.com/wp-json/wp/v2/media?_fields=id,guid&per_page=100";
                String string = "";
                for (int i2 = 0; i2 < articlePublierWordpresses.size(); ++i2) {
                    if (i2 == articlePublierWordpresses.size() - 1) {
                        String string2 = (String)var11_14 + ((ArticlePublierWordpress)articlePublierWordpresses.get(i2)).getImageid();
                        continue;
                    }
                    String string3 = (String)var11_14 + ((ArticlePublierWordpress)articlePublierWordpresses.get(i2)).getImageid() + ",";
                }
                String[] imagesidsarray = var11_14.split(",");
                String[][] sousTableauximagesids = this.diviserTableau(imagesidsarray, 100);
                ArrayList<Object> mediaWPList = new ArrayList<Object>();
                for (int i3 = 0; i3 < sousTableauximagesids.length; ++i3) {
                    String imgids = String.join((CharSequence)",", sousTableauximagesids[i3]);
                    ResponseEntity resp = this.restTemplate.exchange(baseWPimagesUrl + "&include=" + imgids, HttpMethod.GET, null, MediaWP[].class, new Object[0]);
                    mediaWPList.addAll(Arrays.asList((Object[])resp.getBody()));
                }
                block6: for (ArticlePublierWordpress articlePublierWordpress : articlePublierWordpresses) {
                    for (MediaWP mediaWP : mediaWPList) {
                        if (!Objects.equals(articlePublierWordpress.getImageid(), mediaWP.getId())) continue;
                        String imageurl = mediaWP.getGuid().getRendered();
                        String imageurl350x196 = imageurl.substring(0, imageurl.length() - 4) + "-350x196.jpg";
                        articlePublierWordpress.setImageUrl(imageurl350x196);
                        String[] tableau = imageurl350x196.split("/");
                        String imagesArticlespubliesPath = "/home/hostpeak/public_html/ImagesArticlespublies/" + tableau[tableau.length - 1];
                        ResponseEntity Imageresponse = this.restTemplate.getForEntity(imageurl350x196, byte[].class, new Object[0]);
                        if (response.getStatusCode().is2xxSuccessful()) {
                            try {
                                FileOutputStream fos = new FileOutputStream(imagesArticlespubliesPath);
                                fos.write((byte[])Imageresponse.getBody());
                                fos.close();
                                articlePublierWordpress.setImagelocal(tableau[tableau.length - 1]);
                                System.out.println("L'image a \u00e9t\u00e9 t\u00e9l\u00e9charg\u00e9e avec succ\u00e8s dans " + imagesArticlespubliesPath);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            continue block6;
                        }
                        System.err.println("\u00c9chec du t\u00e9l\u00e9chargement de l'image depuis WordPress. Code de statut : " + response.getStatusCodeValue());
                        continue block6;
                    }
                }
                this.articlePublierWordpressRepository.saveAll(articlePublierWordpresses);
            }
        }
    }

    public String[][] diviserTableau(String[] tableau, int tailleSousTableau) {
        int nombreSousTableaux = (int)Math.ceil((double)tableau.length / (double)tailleSousTableau);
        String[][] sousTableaux = new String[nombreSousTableaux][];
        for (int i = 0; i < nombreSousTableaux; ++i) {
            int debut = i * tailleSousTableau;
            int fin = Math.min(debut + tailleSousTableau, tableau.length);
            String[] sousTableau = Arrays.copyOfRange(tableau, debut, fin);
            sousTableaux[i] = sousTableau;
        }
        return sousTableaux;
    }

    public void resizeImage(String inputImagePath, String outputImagePath) {
        try {
            File fileToDelete = new File(outputImagePath);
            if (fileToDelete.exists()) {
                fileToDelete.delete();
            }
            Thumbnails.of((String[])new String[]{inputImagePath}).size(82, 82).outputQuality(1.0).outputFormat("jpeg").toFile(outputImagePath);
            System.out.println("image resized to 82 x 82");
        }
        catch (IOException e) {
            System.out.println("IMAGE NOT RESIZED TO 82 x 82");
        }
    }

    public String getvideo(String videoname) throws IOException {
        return this.photoService.getVideo(videoname);
    }

    public String getaudio(String audioname) throws IOException {
        return this.photoService.getAudio(audioname);
    }

    public List<String> getAutresimagesbyArticle(Long id) throws IOException {
        Optional article = this.articleRepository.findById((Object)id);
        ArrayList<String> medias = new ArrayList<String>();
        if (article.isPresent() && ((Article)article.get()).getAutresImages() != null) {
            medias.addAll(this.photoService.getAllPhotos(((Article)article.get()).getAutresImages().split("/")));
        }
        return medias;
    }

    public List<Article> getAllArticles() {
        return this.articleRepository.findAll();
    }

    private long calculateContentLength(List<Article> list) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString(list);
        return jsonString.getBytes().length;
    }

    public ResponseEntity<List<ArticleAuteur>> getAllByActeurID(Long id) throws IOException {
        List articles = this.articleRepository.findByAuteurIDOrderByDateCreationDesc(id);
        List articleAuteurs = new ArrayList();
        if (!articles.isEmpty()) {
            articleAuteurs = this.articleMapper.ArticlesToArticleAuteurs(articles);
            for (ArticleAuteur a : articleAuteurs) {
                if (a.getImage82() == null) continue;
                a.setImage82(this.photoService.getPhoto82(a.getImage82()));
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString(articleAuteurs);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(articleAuteurs);
    }

    @Transactional
    public ResponseEntity<ArticlesAuteurDTO> getAllArticlesByActeurID(Long id, int pageNumber) throws IOException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)10);
        System.out.println(pageRequest);
        Page page = this.articleRepository.findByAuteurIDOrderByDateCreationDesc(id, (Pageable)pageRequest);
        System.out.println(page);
        List articles = page.getContent();
        System.out.println("nombre total de pages : " + page.getTotalPages());
        ArticlesAuteurDTO articlesAuteurDTO = new ArticlesAuteurDTO();
        if (!articles.isEmpty()) {
            List articleAuteurs = this.articleMapper.ArticlesToArticleAuteurs(articles);
            for (ArticleAuteur a : articleAuteurs) {
                if (a.getImage82() == null) continue;
                a.setImage82(this.photoService.getPhoto82(a.getImage82()));
            }
            articlesAuteurDTO.setArticles(articleAuteurs);
            articlesAuteurDTO.setTotalPages(page.getTotalPages());
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)articlesAuteurDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articlesAuteurDTO);
    }

    @Transactional
    public ResponseEntity<ArticlesAuteurDTO> FiltrerArticlesByActeurIDAndStatus(Long id, String status, int pageNumber) throws IOException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)10);
        System.out.println(pageRequest);
        Page page = this.articleRepository.findByAuteurIDAndStatusOrderByDateCreationDesc(id, status, (Pageable)pageRequest);
        System.out.println(page);
        List articles = page.getContent();
        System.out.println("nombre total de pages : " + page.getTotalPages());
        ArticlesAuteurDTO articlesAuteurDTO = new ArticlesAuteurDTO();
        if (!articles.isEmpty()) {
            List articleAuteurs = this.articleMapper.ArticlesToArticleAuteurs(articles);
            for (ArticleAuteur a : articleAuteurs) {
                if (a.getImage82() == null) continue;
                a.setImage82(this.photoService.getPhoto82(a.getImage82()));
            }
            articlesAuteurDTO.setArticles(articleAuteurs);
            articlesAuteurDTO.setTotalPages(page.getTotalPages());
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)articlesAuteurDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articlesAuteurDTO);
    }

    @Transactional
    public ResponseEntity<ArticlesAuteurDTO> RechercherArticlesByActeurID(Long id, String rech, int pageNumber) throws IOException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)10);
        System.out.println(pageRequest);
        Page page = this.articleRepository.findByAuteurIDAndTitreContainingIgnoreCaseOrderByDateCreationDesc(id, rech, (Pageable)pageRequest);
        System.out.println(page);
        List articles = page.getContent();
        System.out.println("nombre total de pages : " + page.getTotalPages());
        ArticlesAuteurDTO articlesAuteurDTO = new ArticlesAuteurDTO();
        if (!articles.isEmpty()) {
            List articleAuteurs = this.articleMapper.ArticlesToArticleAuteurs(articles);
            for (ArticleAuteur a : articleAuteurs) {
                if (a.getImage82() == null) continue;
                a.setImage82(this.photoService.getPhoto82(a.getImage82()));
            }
            articlesAuteurDTO.setArticles(articleAuteurs);
            articlesAuteurDTO.setTotalPages(page.getTotalPages());
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)articlesAuteurDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articlesAuteurDTO);
    }

    @Transactional
    public ResponseEntity<List<ArticleStatusDTO>> getAllByActeurIDAndStatus(Long id, String status) throws IOException {
        List articles = this.articleRepository.findByAuteurIDAndStatusOrderByDateCreationDesc(id, status);
        List articleStatusDTOS = new ArrayList();
        if (!articles.isEmpty()) {
            articleStatusDTOS = this.articleMapper.ArticlesToArticleStatusDTOs(articles);
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString(articleStatusDTOS);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(articleStatusDTOS);
    }

    @Transactional
    public ResponseEntity<ArticlesBrouillonAuteurDTO> getArticlesBrouillonsByAuteurId(Long id, String rech, int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)10);
        Page page = null;
        System.out.println(pageRequest);
        page = rech != null ? this.articleRepository.findByAuteurIDAndStatusAndTitreContainingIgnoreCaseOrderByDateCreationDesc(id, "Brouillon", rech, (Pageable)pageRequest) : this.articleRepository.findByAuteurIDAndStatusOrderByDateCreationDesc(id, "Brouillon", (Pageable)pageRequest);
        System.out.println(page);
        List articles = page.getContent();
        System.out.println("nombre total de pages : " + page.getTotalPages());
        ArticlesBrouillonAuteurDTO articlesBrouillonAuteurDTO = new ArticlesBrouillonAuteurDTO();
        if (!articles.isEmpty()) {
            List articleBrouillons = this.articleMapper.ArticlesToArticleBrouillons(articles);
            articlesBrouillonAuteurDTO.setArticles(articleBrouillons);
            articlesBrouillonAuteurDTO.setTotalPages(page.getTotalPages());
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)articlesBrouillonAuteurDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articlesBrouillonAuteurDTO);
    }

    @Transactional
    public ResponseEntity<ArticlesRejetesAuteurDTO> getArticlesRejetesByAuteurId(Long id, String rech, int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)10);
        System.out.println(pageRequest);
        Page page = null;
        page = rech != null ? this.articleRepository.findByAuteurIDAndStatusAndTitreContainingIgnoreCaseOrderByDateCreationDesc(id, "Rejet\u00e9", rech, (Pageable)pageRequest) : this.articleRepository.findByAuteurIDAndStatusOrderByDateCreationDesc(id, "Rejet\u00e9", (Pageable)pageRequest);
        System.out.println(page);
        List articles = page.getContent();
        System.out.println("nombre total de pages : " + page.getTotalPages());
        ArticlesRejetesAuteurDTO articlesRejetesAuteurDTO = new ArticlesRejetesAuteurDTO();
        if (!articles.isEmpty()) {
            List articleRejetes = this.articleMapper.ArticlesToArticleRejetes(articles);
            articlesRejetesAuteurDTO.setArticles(articleRejetes);
            articlesRejetesAuteurDTO.setTotalPages(page.getTotalPages());
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)articlesRejetesAuteurDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articlesRejetesAuteurDTO);
    }

    @Transactional
    public ResponseEntity<ArticlesValidesAuteurDTO> getArticlesValidesByAuteurId(Long id, String rech, int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)10);
        System.out.println(pageRequest);
        Page page = null;
        page = rech != null ? this.articleRepository.findByAuteurIDAndStatusAndTitreContainingIgnoreCaseOrderByDateCreationDesc(id, "Valid\u00e9 (en ligne)", rech, (Pageable)pageRequest) : this.articleRepository.findByAuteurIDAndStatusOrderByDateCreationDesc(id, "Valid\u00e9 (en ligne)", (Pageable)pageRequest);
        System.out.println(page);
        List articles = page.getContent();
        System.out.println("nombre total de pages : " + page.getTotalPages());
        ArticlesValidesAuteurDTO articlesValidesAuteurDTO = new ArticlesValidesAuteurDTO();
        if (!articles.isEmpty()) {
            List articleValides = this.articleMapper.ArticlesToArticleValides(articles);
            articlesValidesAuteurDTO.setArticles(articleValides);
            articlesValidesAuteurDTO.setTotalPages(page.getTotalPages());
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)articlesValidesAuteurDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articlesValidesAuteurDTO);
    }

    @Transactional
    public ResponseEntity<ArticlesValidationEnCoursAuteurDTO> getArticlesValidationencoursByAuteurId(Long id, String rech, int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)10);
        System.out.println(pageRequest);
        Page page = null;
        page = rech != null ? this.articleRepository.findByAuteurIDAndStatusAndTitreContainingIgnoreCaseOrderByDateCreationDesc(id, "Validation en cours", rech, (Pageable)pageRequest) : this.articleRepository.findByAuteurIDAndStatusOrderByDateCreationDesc(id, "Validation en cours", (Pageable)pageRequest);
        System.out.println(page);
        List articles = page.getContent();
        System.out.println("nombre total de pages : " + page.getTotalPages());
        ArticlesValidationEnCoursAuteurDTO articlesValidationEnCoursAuteurDTO = new ArticlesValidationEnCoursAuteurDTO();
        if (!articles.isEmpty()) {
            List articleEnCoursDeValidations = this.articleMapper.ArticlesToArticleEnCoursDeValidations(articles);
            articlesValidationEnCoursAuteurDTO.setArticles(articleEnCoursDeValidations);
            articlesValidationEnCoursAuteurDTO.setTotalPages(page.getTotalPages());
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)articlesValidationEnCoursAuteurDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articlesValidationEnCoursAuteurDTO);
    }

    public ResponseEntity<ArticleDto> getArticleByID(Long id) throws IOException {
        Optional article = this.articleRepository.findById((Object)id);
        if (article.isPresent()) {
            ArticleDto articleDto = new ArticleDto();
            ((Article)article.get()).setImage(this.photoService.getPhoto(((Article)article.get()).getImage()));
            articleDto.setArticle((Article)article.get());
            if (((Article)article.get()).getAutresImages() != null) {
                articleDto.setAutresimags(this.photoService.getAllPhotos(((Article)article.get()).getAutresImages().split("/")));
            }
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString((Object)articleDto);
            long contentLength = jsonString.getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articleDto);
        }
        return null;
    }

    @Transactional
    public Article AddArticle(MultipartFile file, Optional<MultipartFile[]> files, Optional<MultipartFile> audioVideo, String article) throws JsonProcessingException {
        Article article1 = (Article)new ObjectMapper().readValue(article, Article.class);
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String dateString = format.format(new Date());
        article1.setPageViews(Long.valueOf(0L));
        article1.setAreactiver(Boolean.valueOf(false));
        article1.setAdesactiver(Boolean.valueOf(false));
        article1.setTitre(this.emojiUtilsService.removeEmojis(article1.getTitre()));
        article1.setContenu(this.emojiUtilsService.removeEmojis(article1.getContenu()));
        article1.setTitre(this.emojiUtilsService.removeHtmlTags(article1.getTitre()));
        article1.setContenu(this.emojiUtilsService.removeHtmlTags(article1.getContenu()));
        article1.setPseudoauteur(this.emojiUtilsService.removeEmojis(article1.getPseudoauteur()));
        article1.setPseudoauteur(this.emojiUtilsService.removeHtmlTags(article1.getPseudoauteur()));
        article1.setLienyoutube(this.emojiUtilsService.removeEmojis(article1.getLienyoutube()));
        article1.setLienyoutube(this.emojiUtilsService.removeHtmlTags(article1.getLienyoutube()));
        try {
            String extension = "";
            extension = file.getContentType() != null ? file.getContentType().split("/")[1] : "jpeg";
            String filename = "article-" + article1.getAuteurID() + "-" + dateString + "." + extension;
            Files.copy(file.getInputStream(), this.root.resolve(filename), new CopyOption[0]);
            this.resizeImage("/home/hostpeak/public_html/Uploads/" + filename, "/home/hostpeak/public_html/Uploads82/" + filename);
            article1.setImage(filename);
            article1.setImage82(filename);
            if (files.isPresent()) {
                String autresFilenames = "";
                for (int i = 0; i < files.get().length; ++i) {
                    String filenamee = "article-" + i + "-" + article1.getAuteurID() + "-" + dateString + "." + files.get()[i].getContentType().split("/")[1];
                    Files.copy(files.get()[i].getInputStream(), this.root.resolve(filenamee), new CopyOption[0]);
                    this.resizeImage("/home/hostpeak/public_html/Uploads/" + filenamee, "/home/hostpeak/public_html/Uploads82/" + filenamee);
                    autresFilenames = autresFilenames + filenamee + "/";
                }
                article1.setAutresImages(autresFilenames);
                article1.setAutresImages82(autresFilenames);
            }
            if (audioVideo.isPresent() && audioVideo.get().getContentType() != null) {
                String audioOuVideoname;
                if (audioVideo.get().getContentType().split("/")[0].equals("audio")) {
                    audioOuVideoname = "audio-" + article1.getAuteurID() + "-" + dateString + "." + audioVideo.get().getContentType().split("/")[1];
                    Files.copy(audioVideo.get().getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                    article1.setAudio(audioOuVideoname);
                } else if (audioVideo.get().getContentType().split("/")[0].equals("video")) {
                    audioOuVideoname = "video-" + article1.getAuteurID() + "-" + dateString + ".mp4";
                    Files.copy(audioVideo.get().getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                    article1.setVideo(audioOuVideoname);
                }
            }
            return (Article)this.articleRepository.save((Object)article1);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not store the file . Error: " + e.getMessage());
        }
    }

    @Transactional
    public Article AddVideo(MultipartFile audioVideo, String article) throws JsonProcessingException {
        Article article1 = (Article)new ObjectMapper().readValue(article, Article.class);
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String dateString = format.format(new Date());
        article1.setTitre(this.emojiUtilsService.removeEmojis(article1.getTitre()));
        article1.setContenu(this.emojiUtilsService.removeEmojis(article1.getContenu()));
        try {
            String filename = "articleVideo-" + article1.getAuteurID() + "-" + dateString + "." + audioVideo.getContentType().split("/")[1];
            Files.copy(audioVideo.getInputStream(), this.root.resolve(filename), new CopyOption[0]);
            if (audioVideo.getContentType().split("/")[0].equals("audio")) {
                String audioOuVideoname = "audio-" + article1.getAuteurID() + "-" + dateString + "." + audioVideo.getContentType().split("/")[1];
                Files.copy(audioVideo.getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                article1.setAudio(audioOuVideoname);
            } else if (audioVideo.getContentType().split("/")[0].equals("video")) {
                String audioOuVideoname = "video-" + article1.getAuteurID() + "-" + dateString + ".mp4";
                Files.copy(audioVideo.getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                article1.setVideo(audioOuVideoname);
            }
            return (Article)this.articleRepository.save((Object)article1);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not store the file . Error: " + e.getMessage());
        }
    }

    @Transactional
    public Article ModifierArticle(Optional<MultipartFile> file, Optional<MultipartFile[]> files, Optional<MultipartFile> audioVideo, String newarticle) throws JsonProcessingException {
        Article article = (Article)new ObjectMapper().readValue(newarticle, Article.class);
        article.setTitre(this.emojiUtilsService.removeEmojis(article.getTitre()));
        article.setContenu(this.emojiUtilsService.removeEmojis(article.getContenu()));
        article.setTitre(this.emojiUtilsService.removeHtmlTags(article.getTitre()));
        article.setContenu(this.emojiUtilsService.removeHtmlTags(article.getContenu()));
        article.setPseudoauteur(this.emojiUtilsService.removeEmojis(article.getPseudoauteur()));
        article.setPseudoauteur(this.emojiUtilsService.removeHtmlTags(article.getPseudoauteur()));
        article.setLienyoutube(this.emojiUtilsService.removeEmojis(article.getLienyoutube()));
        article.setLienyoutube(this.emojiUtilsService.removeHtmlTags(article.getLienyoutube()));
        Article article1 = (Article)this.articleRepository.findById((Object)article.getId()).get();
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String dateString = format.format(new Date());
        try {
            if (file.isPresent()) {
                Files.deleteIfExists(this.root.resolve(article1.getImage()));
                String filename = "article-" + article1.getAuteurID() + "-" + dateString + "." + file.get().getContentType().split("/")[1];
                Files.copy(file.get().getInputStream(), this.root.resolve(filename), new CopyOption[0]);
                article1.setImage(filename);
            }
            if (files.isPresent()) {
                if (article.getAutresImages() != null) {
                    this.photoService.deleteAllPhotos(article1.getAutresImages().split("/"));
                }
                String autresFilenames = "";
                for (int i = 0; i < files.get().length; ++i) {
                    String filenamee = "article-" + i + "-" + article1.getAuteurID() + "-" + dateString + "." + files.get()[i].getContentType().split("/")[1];
                    Files.copy(files.get()[i].getInputStream(), this.root.resolve(filenamee), new CopyOption[0]);
                    autresFilenames = autresFilenames + filenamee + "/";
                }
                article1.setAutresImages(autresFilenames);
            }
            if (audioVideo.isPresent()) {
                if (article1.getVideo() != null) {
                    Files.deleteIfExists(this.root.resolve(article1.getVideo()));
                }
                if (article1.getAudio() != null) {
                    Files.deleteIfExists(this.root.resolve(article1.getAudio()));
                }
                String audioOuVideoname = "audioOuVideo-" + article1.getAuteurID() + "-" + dateString + "." + audioVideo.get().getContentType().split("/")[1];
                Files.copy(audioVideo.get().getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                if (audioVideo.get().getContentType().split("/")[0].equals("audio")) {
                    article1.setAudio(audioOuVideoname);
                } else if (audioVideo.get().getContentType().split("/")[0].equals("video")) {
                    article1.setVideo(audioOuVideoname);
                }
            }
            article1.setAnonymat(article.getAnonymat());
            article1.setApercu(article.getApercu());
            article1.setContenu(article.getContenu());
            article1.setCategorie(article.getCategorie());
            article1.setLienyoutube(article.getLienyoutube());
            article1.setTitre(article.getTitre());
            article1.setPseudoauteur(article.getPseudoauteur());
            article1.setStatus(article.getStatus());
            article1.setWordpressID(article.getWordpressID());
            return (Article)this.articleRepository.save((Object)article1);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not store the file . Error: " + e.getMessage());
        }
    }

    @Transactional
    public Article ModifyArticle(Optional<MultipartFile> file, Optional<String> files, Optional<MultipartFile> audioVideo, String newarticle) throws JsonProcessingException {
        Article article = (Article)new ObjectMapper().readValue(newarticle, Article.class);
        article.setTitre(this.emojiUtilsService.removeEmojis(article.getTitre()));
        article.setContenu(this.emojiUtilsService.removeEmojis(article.getContenu()));
        article.setTitre(this.emojiUtilsService.removeHtmlTags(article.getTitre()));
        article.setContenu(this.emojiUtilsService.removeHtmlTags(article.getContenu()));
        article.setPseudoauteur(this.emojiUtilsService.removeEmojis(article.getPseudoauteur()));
        article.setPseudoauteur(this.emojiUtilsService.removeHtmlTags(article.getPseudoauteur()));
        article.setLienyoutube(this.emojiUtilsService.removeEmojis(article.getLienyoutube()));
        article.setLienyoutube(this.emojiUtilsService.removeHtmlTags(article.getLienyoutube()));
        Article article1 = (Article)this.articleRepository.findById((Object)article.getId()).get();
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String dateString = format.format(new Date());
        try {
            if (file.isPresent()) {
                Files.deleteIfExists(this.root.resolve(article1.getImage()));
                new File("/home/hostpeak/public_html/Uploads82/" + article1.getImage82()).delete();
                String filename = "article-" + article1.getAuteurID() + "-" + dateString + "." + file.get().getContentType().split("/")[1];
                Files.copy(file.get().getInputStream(), this.root.resolve(filename), new CopyOption[0]);
                this.resizeImage("/home/hostpeak/public_html/Uploads/" + filename, "/home/hostpeak/public_html/Uploads82/" + filename);
                article1.setImage(filename);
                article1.setImage82(filename);
            }
            if (files.isPresent()) {
                if (article.getAutresImages() != null) {
                    this.photoService.deleteAllPhotos(article1.getAutresImages().split("/"));
                }
                String autresFilenames = this.photoService.SaveFiles(Arrays.asList(files.get().split("@")), article1.getAuteurID());
                article1.setAutresImages(autresFilenames);
                article1.setAutresImages82(autresFilenames);
            } else {
                article1.setAutresImages82(null);
                article1.setAutresImages(null);
            }
            if (audioVideo.isPresent()) {
                String audioOuVideoname;
                if (article1.getVideo() != null) {
                    Files.deleteIfExists(this.root.resolve(article1.getVideo()));
                }
                if (article1.getAudio() != null) {
                    Files.deleteIfExists(this.root.resolve(article1.getAudio()));
                }
                if (audioVideo.get().getContentType().split("/")[0].equals("audio")) {
                    audioOuVideoname = "audio-" + article1.getAuteurID() + "-" + dateString + "." + audioVideo.get().getContentType().split("/")[1];
                    Files.copy(audioVideo.get().getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                    article1.setAudio(audioOuVideoname);
                } else if (audioVideo.get().getContentType().split("/")[0].equals("video")) {
                    audioOuVideoname = "video-" + article1.getAuteurID() + "-" + dateString + ".mp4";
                    Files.copy(audioVideo.get().getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                    article1.setVideo(audioOuVideoname);
                }
            } else if (article.getVideo() != null && article.getVideo().equals("asupprimer")) {
                Files.deleteIfExists(this.root.resolve(article1.getVideo()));
                article1.setVideo(null);
            }
            article1.setSousdomaine(article.getSousdomaine());
            article1.setAnonymat(article.getAnonymat());
            article1.setApercu(article.getApercu());
            article1.setContenu(article.getContenu());
            article1.setCategorie(article.getCategorie());
            article1.setLienyoutube(article.getLienyoutube());
            article1.setTitre(article.getTitre());
            article1.setPseudoauteur(article.getPseudoauteur());
            article1.setStatus(article.getStatus());
            article1.setWordpressID(article.getWordpressID());
            return (Article)this.articleRepository.save((Object)article1);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not store the file . Error: " + e.getMessage());
        }
    }

    @Transactional
    public Article UpdateStatus(Long id, String status) {
        Article article = (Article)this.articleRepository.findById((Object)id).get();
        article.setStatus(status);
        return (Article)this.articleRepository.save((Object)article);
    }

    @Transactional
    public String deleteArticle(Long id) {
        Article article = (Article)this.articleRepository.findById((Object)id).get();
        try {
            Files.deleteIfExists(this.root.resolve(article.getImage()));
            if (article.getVideo() != null) {
                Files.deleteIfExists(this.root.resolve(article.getVideo()));
            }
            if (article.getAudio() != null) {
                Files.deleteIfExists(this.root.resolve(article.getAudio()));
            }
            if (article.getAutresImages() != null) {
                this.photoService.deleteAllPhotos(article.getAutresImages().split("/"));
            }
            this.articleRepository.deleteById((Object)id);
            return "Article supprim\u00e9 !!!";
        }
        catch (IOException e) {
            throw new RuntimeException("Could not delete the file . Error: " + e.getMessage());
        }
    }

    @Transactional
    public String deleteArticles(List<Long> ids) {
        List articles = this.articleRepository.findAllById(ids);
        try {
            for (int i = 0; i < articles.size(); ++i) {
                Files.deleteIfExists(this.root.resolve(((Article)articles.get(i)).getImage()));
                if (((Article)articles.get(i)).getVideo() != null) {
                    Files.deleteIfExists(this.root.resolve(((Article)articles.get(i)).getVideo()));
                }
                if (((Article)articles.get(i)).getAudio() != null) {
                    Files.deleteIfExists(this.root.resolve(((Article)articles.get(i)).getAudio()));
                }
                if (((Article)articles.get(i)).getAutresImages() == null) continue;
                this.photoService.deleteAllPhotos(((Article)articles.get(i)).getAutresImages().split("/"));
            }
            this.articleRepository.deleteAllById(ids);
            return "Articles supprim\u00e9s !!!";
        }
        catch (IOException e) {
            throw new RuntimeException("Could not delete the file . Error: " + e.getMessage());
        }
    }
}

