/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.ComptesLienPrivilege;
import com.notrecontinent.webapi.entities.Lienprivilege;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.PointsLienPrivilege;
import com.notrecontinent.webapi.entities.Recommandation;
import com.notrecontinent.webapi.repositories.ArticleRepository;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.ComptesLienPrivilegeRepository;
import com.notrecontinent.webapi.repositories.LienprivilegeRepository;
import com.notrecontinent.webapi.repositories.PointLienPrivilegeRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import com.notrecontinent.webapi.services.MailService;
import com.notrecontinent.webapi.services.SmsService;
import com.notrecontinent.webapi.services.WhatsappService;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MissionService {
    @Autowired
    private LienprivilegeRepository lienprivilegeRepository;
    @Autowired
    private ComptesLienPrivilegeRepository comptesLienPrivilegeRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private SmsService smsService;
    @Autowired
    private MailService mailService;
    @Autowired
    private WhatsappService whatsappService;
    @Autowired
    private PointLienPrivilegeRepository pointLienPrivilegeRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private ArticleRepository articleRepository;
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Value(value="${parametre.lien.privilege}")
    private Long param;

    @Transactional
    public void envoyerLiensPrivileges1() {
        List missions = this.lienprivilegeRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!missions.isEmpty()) {
            Date currentdate = new Date();
            ArrayList<Lienprivilege> missions2 = new ArrayList<Lienprivilege>();
            for (Lienprivilege m : missions) {
                if ((currentdate.getTime() - m.getDateCreation().getTime()) / 3600000L < 24L) continue;
                missions2.add(m);
            }
            if (!missions2.isEmpty()) {
                ArrayList missionList = new ArrayList();
                missionList.addAll(this.smsService.EnvoyerLiensPrivileges(missions2));
                this.lienprivilegeRepository.saveAll(missionList);
            }
        }
    }

    @Transactional
    public void envoyerLiensPrivileges2() {
        List missions = this.lienprivilegeRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!missions.isEmpty()) {
            Date currentdate = new Date();
            ArrayList<Lienprivilege> missions2 = new ArrayList<Lienprivilege>();
            for (Lienprivilege m : missions) {
                if ((currentdate.getTime() - m.getDateCreation().getTime()) / 3600000L < 24L) continue;
                missions2.add(m);
            }
            if (!missions2.isEmpty()) {
                ArrayList missionList = new ArrayList();
                missionList.addAll(this.smsService.EnvoyerLiensPrivileges(missions2));
                this.lienprivilegeRepository.saveAll(missionList);
            }
        }
    }

    @Transactional
    public String GenererLienPrivilege(Lienprivilege lienprivilege) {
        Lienprivilege lienprivilege1 = this.lienprivilegeRepository.findByAuteurid(lienprivilege.getAuteurid());
        if (lienprivilege1 != null) {
            return "en commission de validation";
        }
        Lienprivilege mission1 = this.lienprivilegeRepository.findByParametre(this.param);
        if (mission1 != null) {
            Lienprivilege mission2 = this.lienprivilegeRepository.findFirstByOrderByIdDesc();
            this.param = mission2.getParametre() + 1L;
        }
        String lienPrivilege = "https://lk.clickofafrica.com/?p=dev/";
        lienPrivilege = lienPrivilege + this.param;
        lienprivilege.setLienprivilege(lienPrivilege);
        lienprivilege.setParametre(this.param);
        this.lienprivilegeRepository.save((Object)lienprivilege);
        return "lien privil\u00e8ge g\u00e9n\u00e9r\u00e9";
    }

    public void SaveComptelienPrivilege(Long paramlien, Long idcompte, String usernamecompte) {
        Lienprivilege lienprivilege = this.lienprivilegeRepository.findByParametre(paramlien);
        if (lienprivilege != null) {
            ComptesLienPrivilege comptesLienPrivilege = new ComptesLienPrivilege();
            comptesLienPrivilege.setIdcomptecreer(idcompte);
            comptesLienPrivilege.setIdcompteproplien(lienprivilege.getAuteurid());
            comptesLienPrivilege.setUsernamecomptecreer(usernamecompte);
            comptesLienPrivilege.setLienprivilege(lienprivilege.getLienprivilege());
            comptesLienPrivilege.setEsttraiter(Boolean.valueOf(false));
            Auteur auteur = (Auteur)this.auteurRepository.findById((Object)lienprivilege.getAuteurid()).get();
            comptesLienPrivilege.setUsernamecompteproplien(auteur.getUsername());
            this.comptesLienPrivilegeRepository.save((Object)comptesLienPrivilege);
        }
    }

    @Transactional
    public ResponseEntity<Lienprivilege> getlienprivilegebyauteurid(Long auteurid) throws JsonProcessingException {
        Lienprivilege lienprivilege = this.lienprivilegeRepository.findByAuteuridAndEstenvoyer(auteurid, Boolean.valueOf(true));
        if (lienprivilege == null) {
            lienprivilege = new Lienprivilege();
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)lienprivilege);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)lienprivilege);
    }

    @Transactional
    public void AffecterlespointsLP() {
        List comptesLienPrivilegeList = this.comptesLienPrivilegeRepository.findByEsttraiter(Boolean.valueOf(false));
        if (!comptesLienPrivilegeList.isEmpty()) {
            LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
            Date currentdate = Date.from(now.atZone(ZoneId.of("GMT")).toInstant());
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
            String mois = dateFormat.format(currentdate);
            HashSet<Long> idsauteur = new HashSet<Long>();
            for (ComptesLienPrivilege c2 : comptesLienPrivilegeList) {
                idsauteur.add(c2.getIdcompteproplien());
            }
            for (Long id : idsauteur) {
                Optional auteurr;
                Auteur auteur2;
                List comptesLienPrivileges = comptesLienPrivilegeList.stream().filter(c -> Objects.equals(c.getIdcompteproplien(), id)).collect(Collectors.toList());
                ArrayList<Long> ids = new ArrayList<Long>();
                for (ComptesLienPrivilege c3 : comptesLienPrivileges) {
                    ids.add(c3.getIdcomptecreer());
                }
                List auteurs = this.auteurRepository.findByIdIn(ids);
                if (auteurs.isEmpty()) continue;
                Long totalpoints = 0L;
                block3: for (Auteur auteur2 : auteurs) {
                    Boolean b;
                    Object recommandations;
                    Boolean ok;
                    if (auteur2.getRole().equals("ami")) {
                        PointsAmi pointsAmi;
                        ok = false;
                        if (auteur2.getCreerpar().equals("email")) {
                            if (auteur2.getPays().equals("S\u00e9n\u00e9gal")) {
                                if (auteur2.getTelephone() != null && !auteur2.getTelephone().equals("") && auteur2.getTelephonevalider().booleanValue()) {
                                    ok = true;
                                }
                            } else {
                                ok = true;
                            }
                        } else {
                            ok = true;
                        }
                        if (!ok.booleanValue() || (pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, auteur2.getId())) == null || pointsAmi.getNbArticlesLus() < 5L || (recommandations = this.recommandationRepository.findByEstcliquerAndAuteuridAndFraude(Boolean.valueOf(true), auteur2.getId(), Boolean.valueOf(false))).isEmpty()) continue;
                        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                        HashSet<String> dateclicks = new HashSet<String>();
                        Iterator iterator = recommandations.iterator();
                        while (iterator.hasNext()) {
                            Recommandation recommandation = (Recommandation)iterator.next();
                            dateclicks.add(sdf.format(recommandation.getDateClick()));
                        }
                        if (dateclicks.isEmpty() || dateclicks.size() < 5) continue;
                        totalpoints = totalpoints + 10L;
                        for (ComptesLienPrivilege c4 : comptesLienPrivilegeList) {
                            if (!Objects.equals(c4.getIdcomptecreer(), auteur2.getId())) continue;
                            c4.setEsttraiter(Boolean.valueOf(true));
                            continue block3;
                        }
                        continue;
                    }
                    if (!auteur2.getRole().equals("contributeur")) continue;
                    ok = false;
                    if (auteur2.getCreerpar().equals("email")) {
                        if (auteur2.getPays().equals("S\u00e9n\u00e9gal")) {
                            if (auteur2.getTelephone() != null && !auteur2.getTelephone().equals("") && auteur2.getTelephonevalider().booleanValue()) {
                                ok = true;
                            }
                        } else {
                            ok = true;
                        }
                    } else {
                        ok = true;
                    }
                    if (!ok.booleanValue() || !(b = this.articleRepository.existsByAuteurIDAndStatus(auteur2.getId(), "Valid\u00e9 (en ligne)")).booleanValue()) continue;
                    totalpoints = totalpoints + 10L;
                    recommandations = comptesLienPrivilegeList.iterator();
                    while (recommandations.hasNext()) {
                        ComptesLienPrivilege c5 = (ComptesLienPrivilege)recommandations.next();
                        if (!Objects.equals(c5.getIdcomptecreer(), auteur2.getId())) continue;
                        c5.setEsttraiter(Boolean.valueOf(true));
                        continue block3;
                    }
                }
                if (totalpoints <= 0L || !(auteurr = this.auteurRepository.findById((Object)id)).isPresent() || (auteur2 = (Auteur)auteurr.get()).getMonetisation() == null || !auteur2.getMonetisation().equals("Oui")) continue;
                Long nbcomptes = totalpoints / 10L;
                PointsLienPrivilege pointsLienPrivilege = this.pointLienPrivilegeRepository.findByAuteuridAndMois(id, mois);
                if (pointsLienPrivilege == null) {
                    PointsLienPrivilege p = new PointsLienPrivilege();
                    p.setAuteurid(id);
                    p.setMois(mois);
                    p.setNbPointsComptesCreer(totalpoints);
                    p.setNbComptesCreer(nbcomptes);
                    p.setRolecompte(auteur2.getRole());
                    this.pointLienPrivilegeRepository.save((Object)p);
                } else {
                    pointsLienPrivilege.setNbComptesCreer(Long.valueOf(pointsLienPrivilege.getNbComptesCreer() + nbcomptes));
                    pointsLienPrivilege.setNbPointsComptesCreer(Long.valueOf(pointsLienPrivilege.getNbPointsComptesCreer() + totalpoints));
                    pointsLienPrivilege.setRolecompte(auteur2.getRole());
                    this.pointLienPrivilegeRepository.save((Object)pointsLienPrivilege);
                }
                if (auteur2.getRole().equals("ami")) {
                    PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, id);
                    if (pointsAmi != null) {
                        pointsAmi.setNbMissions(Long.valueOf(pointsAmi.getNbMissions() + nbcomptes));
                        pointsAmi.setNbPointsMissions(Long.valueOf(pointsAmi.getNbPointsMissions() + totalpoints));
                        pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsMois() + totalpoints));
                        this.pointsAmiRepository.save((Object)pointsAmi);
                    } else {
                        PointsAmi p = new PointsAmi();
                        p.setAmiId(id);
                        p.setNbMissions(nbcomptes);
                        p.setNbPointsMissions(totalpoints);
                        p.setNbPointsMois(totalpoints);
                        p.setNbPointsArticlesLus(Long.valueOf(0L));
                        p.setNbArticlesLus(Long.valueOf(0L));
                        p.setNbRecommandations(Long.valueOf(0L));
                        p.setNbPointsRecommandations(Long.valueOf(0L));
                        p.setMois(mois);
                        this.pointsAmiRepository.save((Object)p);
                    }
                }
                auteur2.setTotalPointsCumules(Long.valueOf(auteur2.getTotalPointsCumules() + totalpoints));
                this.auteurRepository.save((Object)auteur2);
            }
            this.comptesLienPrivilegeRepository.saveAll((Iterable)comptesLienPrivilegeList);
        }
    }

    @Transactional
    @Scheduled(cron="30 15 4 1 * *", zone="GMT")
    public void RecalculerLesPointsmissions() {
        List comptesLienPrivilegeList;
        LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime datelastmonth = now.minusMonths(1L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0);
        Date dateelastmonth = Date.from(datelastmonth.atZone(ZoneId.of("GMT")).toInstant());
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
        String mois = dateFormat.format(dateelastmonth);
        List comptesLienPrivilegeList1 = this.comptesLienPrivilegeRepository.findalloflastmonth(dateelastmonth);
        if (!comptesLienPrivilegeList1.isEmpty() && !(comptesLienPrivilegeList = comptesLienPrivilegeList1.stream().filter(c -> dateFormat.format(c.getDateCreation()).equals(mois)).collect(Collectors.toList())).isEmpty()) {
            HashSet<Long> idsauteur = new HashSet<Long>();
            for (ComptesLienPrivilege c2 : comptesLienPrivilegeList) {
                idsauteur.add(c2.getIdcompteproplien());
            }
            for (Long id : idsauteur) {
                Long nbcomptes = comptesLienPrivilegeList.stream().filter(c -> Objects.equals(c.getIdcompteproplien(), id)).count();
                Auteur auteur = (Auteur)this.auteurRepository.findById((Object)id).get();
                if (auteur.getMonetisation() == null || !auteur.getMonetisation().equals("Oui")) continue;
                PointsLienPrivilege pointsLienPrivilege = this.pointLienPrivilegeRepository.findByAuteuridAndMois(id, mois);
                if (pointsLienPrivilege == null) {
                    PointsLienPrivilege p = new PointsLienPrivilege();
                    p.setAuteurid(id);
                    p.setMois(mois);
                    p.setNbPointsComptesCreer(Long.valueOf(10L * nbcomptes));
                    p.setNbComptesCreer(nbcomptes);
                    p.setRolecompte(auteur.getRole());
                    this.pointLienPrivilegeRepository.save((Object)p);
                } else {
                    pointsLienPrivilege.setNbComptesCreer(nbcomptes);
                    pointsLienPrivilege.setNbPointsComptesCreer(Long.valueOf(10L * nbcomptes));
                    pointsLienPrivilege.setRolecompte(auteur.getRole());
                    this.pointLienPrivilegeRepository.save((Object)pointsLienPrivilege);
                }
                if (auteur.getRole().equals("ami")) {
                    PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, id);
                    if (pointsAmi != null) {
                        pointsAmi.setNbMissions(nbcomptes);
                        pointsAmi.setNbPointsMissions(Long.valueOf(10L * nbcomptes));
                        pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsArticlesLus() + pointsAmi.getNbPointsRecommandations() + 10L * nbcomptes));
                        this.pointsAmiRepository.save((Object)pointsAmi);
                    } else {
                        PointsAmi p = new PointsAmi();
                        p.setAmiId(id);
                        p.setNbMissions(nbcomptes);
                        p.setNbPointsMissions(Long.valueOf(10L * nbcomptes));
                        p.setNbPointsMois(Long.valueOf(10L * nbcomptes));
                        p.setNbPointsArticlesLus(Long.valueOf(0L));
                        p.setNbArticlesLus(Long.valueOf(0L));
                        p.setNbRecommandations(Long.valueOf(0L));
                        p.setNbPointsRecommandations(Long.valueOf(0L));
                        p.setMois(mois);
                        this.pointsAmiRepository.save((Object)p);
                    }
                }
                for (ComptesLienPrivilege comptesLienPrivilege : comptesLienPrivilegeList) {
                    if (!Objects.equals(comptesLienPrivilege.getIdcompteproplien(), id)) continue;
                    comptesLienPrivilege.setEsttraiter(Boolean.valueOf(true));
                }
            }
        }
    }
}

