/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.entities.Lienprivilege;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.LienprivilegeRepository;
import com.notrecontinent.webapi.services.MailService;
import com.notrecontinent.webapi.services.SmsService;
import com.notrecontinent.webapi.services.WhatsappService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MissionService {
    @Autowired
    private LienprivilegeRepository lienprivilegeRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private SmsService smsService;
    @Autowired
    private MailService mailService;
    @Autowired
    private WhatsappService whatsappService;
    @Value(value="${parametre.lien.privilege}")
    private Long param;

    @Transactional
    @Scheduled(cron="10 27 9 * * *", zone="GMT")
    public void envoyerLiensPrivileges1() {
        List missions = this.lienprivilegeRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!missions.isEmpty()) {
            Date currentdate = new Date();
            ArrayList<Lienprivilege> missions2 = new ArrayList<Lienprivilege>();
            for (Lienprivilege m2 : missions) {
                if ((currentdate.getTime() - m2.getDateCreation().getTime()) / 3600000L < 24L) continue;
                missions2.add(m2);
            }
            if (!missions2.isEmpty()) {
                List missionsparSMS = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("sms")).collect(Collectors.toList());
                List missionsparEmail = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("email")).collect(Collectors.toList());
                List missionsparWhatsapp = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("whatsapp")).collect(Collectors.toList());
                ArrayList missionList = new ArrayList();
                if (!missionsparSMS.isEmpty()) {
                    missionList.addAll(this.smsService.EnvoyerLiensPrivileges(missionsparSMS));
                }
                if (!missionsparEmail.isEmpty()) {
                    missionList.addAll(this.mailService.EnvoyerLiensPrivileges(missionsparEmail));
                }
                if (!missionsparWhatsapp.isEmpty()) {
                    missionList.addAll(this.whatsappService.EnvoyerLiensPrivileges(missionsparWhatsapp));
                }
                this.lienprivilegeRepository.saveAll(missionList);
            }
        }
    }

    @Transactional
    @Scheduled(cron="10 14 18 * * *", zone="GMT")
    public void envoyerLiensPrivileges2() {
        List missions = this.lienprivilegeRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!missions.isEmpty()) {
            Date currentdate = new Date();
            ArrayList<Lienprivilege> missions2 = new ArrayList<Lienprivilege>();
            for (Lienprivilege m2 : missions) {
                if ((currentdate.getTime() - m2.getDateCreation().getTime()) / 3600000L < 24L) continue;
                missions2.add(m2);
            }
            if (!missions2.isEmpty()) {
                List missionsparSMS = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("sms")).collect(Collectors.toList());
                List missionsparEmail = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("email")).collect(Collectors.toList());
                List missionsparWhatsapp = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("whatsapp")).collect(Collectors.toList());
                ArrayList missionList = new ArrayList();
                if (!missionsparSMS.isEmpty()) {
                    missionList.addAll(this.smsService.EnvoyerLiensPrivileges(missionsparSMS));
                }
                if (!missionsparEmail.isEmpty()) {
                    missionList.addAll(this.mailService.EnvoyerLiensPrivileges(missionsparEmail));
                }
                if (!missionsparWhatsapp.isEmpty()) {
                    missionList.addAll(this.whatsappService.EnvoyerLiensPrivileges(missionsparWhatsapp));
                }
                this.lienprivilegeRepository.saveAll(missionList);
            }
        }
    }

    @Transactional
    public String GenererLienPrivilege(Lienprivilege lienprivilege) {
        Lienprivilege mission1 = this.lienprivilegeRepository.findByParametre(this.param);
        if (mission1 != null) {
            Lienprivilege mission2 = this.lienprivilegeRepository.findFirstByOrderByIdDesc();
            this.param = mission2.getParametre() + 1L;
        }
        String lienPrivilege = "https://lk.clickofafrica.com/?p=";
        lienPrivilege = lienPrivilege + this.param;
        lienprivilege.setLienprivilege(lienPrivilege);
        lienprivilege.setParametre(this.param);
        this.lienprivilegeRepository.save((Object)lienprivilege);
        return "lien privil\u00e8ge g\u00e9n\u00e9r\u00e9";
    }

    @Transactional
    public ResponseEntity<Lienprivilege> getlienprivilegebyauteurid(Long auteurid) throws JsonProcessingException {
        Lienprivilege lienprivilege = this.lienprivilegeRepository.findByAuteuridAndEstenvoyer(auteurid, Boolean.valueOf(true));
        if (lienprivilege == null) {
            lienprivilege = new Lienprivilege();
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)lienprivilege);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)lienprivilege);
    }
}

