/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.LesDTOs.ArticleWP;
import com.notrecontinent.webapi.LesDTOs.AuteurSMS;
import com.notrecontinent.webapi.dto.ArticleDto;
import com.notrecontinent.webapi.dto.ArticleWordpress;
import com.notrecontinent.webapi.entities.Article;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Categorie;
import com.notrecontinent.webapi.enumeration.SubdomainsPaysEnum;
import com.notrecontinent.webapi.repositories.ArticleRepository;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.services.ArticleService;
import com.notrecontinent.webapi.services.PhotoService;
import com.notrecontinent.webapi.services.SmsService;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ArticleService {
    private final Path root = Paths.get("/home/speak2024/dev.speakyfree.com/Uploads", new String[0]);
    private final Path root82 = Paths.get("/home/speak2024/dev.speakyfree.com/Uploads82", new String[0]);
    private final String imagesPath = "/home/speak2024/dev.speakyfree.com/Uploads";
    private final String imagesPath82 = "/home/speak2024/dev.speakyfree.com/Uploads82";
    private final String dateFormat = "dd-MM-yyyy HH:mm:ss";
    @Autowired
    private ArticleRepository articleRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private PhotoService photoService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SmsService smsService;
    String userPassci = "Momar:Enpc kRrN iRmm scP5 rvzs Muul";
    String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    @Scheduled(cron="0 */4 * * * *")
    @Transactional
    public void VerifValidation() {
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("Validation en cours");
        statusList.add("Valid\u00e9 (en ligne)");
        statusList.add("Rejet\u00e9");
        List articles = this.articleRepository.findByStatusInAndAdesactiverAndAreactiver(statusList, Boolean.valueOf(false), Boolean.valueOf(false));
        for (int i = 0; i < articles.size(); ++i) {
            Long id = ((Article)articles.get(i)).getWordpressID();
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            authHeader = ((Article)articles.get(i)).getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
            headers.set("Authorization", authHeader);
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            try {
                ResponseEntity response = this.restTemplate.exchange(((Article)articles.get(i)).getSousdomaine() + "/wp-json/wp/v2/posts/" + id + "?_fields=status,title,link", HttpMethod.GET, requestEntity, ArticleWordpress.class, new Object[0]);
                ArticleWordpress articleWordpress = (ArticleWordpress)response.getBody();
                if (articleWordpress == null) continue;
                if (articleWordpress.getStatus().equals("publish")) {
                    List result;
                    if (!((Article)articles.get(i)).getStatus().equals("Valid\u00e9 (en ligne)")) {
                        ((Article)articles.get(i)).setLastStatus(((Article)articles.get(i)).getStatus());
                    }
                    if (!((Article)articles.get(i)).getStatus().equals("Validation en cours")) continue;
                    ((Article)articles.get(i)).setStatus("Valid\u00e9 (en ligne)");
                    ((Article)articles.get(i)).setLink(articleWordpress.getLink());
                    ((Article)articles.get(i)).setDatemodification(new Date());
                    ((Article)articles.get(i)).setTitre(articleWordpress.getTitle().getRendered().replace("&rsquo;", "'"));
                    if (((Article)articles.get(i)).getSmsenvoyer().booleanValue() || !((Article)articles.get(i)).getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) || (result = this.auteurRepository.findcolonnessmsById(((Article)articles.get(i)).getAuteurID())).isEmpty()) continue;
                    Object[] row = (Object[])result.get(0);
                    AuteurSMS auteurSMS = new AuteurSMS((String)row[0], (String)row[1], (String)row[2]);
                    System.out.println("-------");
                    System.out.println(auteurSMS);
                    System.out.println("-------");
                    if (auteurSMS == null) continue;
                    String telephone = auteurSMS.getUsername();
                    String lastname = auteurSMS.getLast_name();
                    String civilite = auteurSMS.getCivilite();
                    String message = this.smsService.EnvoyerSmsValidationArticle(telephone, lastname, civilite, ((Article)articles.get(i)).getLink());
                    ((Article)articles.get(i)).setSmsenvoyer(Boolean.valueOf(true));
                    continue;
                }
                if (articleWordpress.getStatus().equals("trash") && !((Article)articles.get(i)).getStatus().equals("Rejet\u00e9")) {
                    ((Article)articles.get(i)).setLastStatus(((Article)articles.get(i)).getStatus());
                    ((Article)articles.get(i)).setStatus("Rejet\u00e9");
                    ((Article)articles.get(i)).setDatemodification(new Date());
                    continue;
                }
                if (!articleWordpress.getStatus().equals("draft") || ((Article)articles.get(i)).getStatus().equals("Validation en cours")) continue;
                ((Article)articles.get(i)).setLastStatus(((Article)articles.get(i)).getStatus());
                ((Article)articles.get(i)).setStatus("Validation en cours");
                ((Article)articles.get(i)).setDatemodification(new Date());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.articleRepository.saveAll((Iterable)articles);
    }

    @Scheduled(cron="0 */6 * * * *")
    @Transactional
    public void PublierArticles() {
        List articles = this.articleRepository.findByStatusAndWordpressIDIsNull("Validation en cours");
        if (!articles.isEmpty()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes());
            headers.set("Authorization", authHeader);
            HttpEntity categoriesRequestEntity = new HttpEntity((MultiValueMap)headers);
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, categoriesRequestEntity, Categorie[].class, new Object[0]).getBody());
            for (Categorie categorie : categories) {
                if (categorie.getName().equals("Art &amp; Culture")) {
                    categorie.setName("Art & Culture");
                    continue;
                }
                if (categorie.getName().equals("Soir\u00e9e &amp; \u00e9v\u00e8nement")) {
                    categorie.setName("Soir\u00e9e & \u00e9v\u00e8nement");
                    continue;
                }
                if (!categorie.getName().equals("Tourisme &amp; Voyage")) continue;
                categorie.setName("Tourisme & Voyage");
            }
            for (Article article : articles) {
                ResponseEntity responseEntity;
                HttpEntity imageEntity;
                headers = new HttpHeaders();
                authHeader = article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                headers.set("Authorization", authHeader);
                ArticleWP articleWP = new ArticleWP();
                articleWP.setStatus("draft");
                articleWP.setContent(article.getContenu());
                articleWP.setTitle(article.getTitre());
                Auteur auteur = (Auteur)this.auteurRepository.findById((Object)article.getAuteurID()).get();
                if (article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain())) {
                    articleWP.setAuthor(auteur.getWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.CA.getSubdomain())) {
                    articleWP.setAuthor(auteur.getCaWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.BJ.getSubdomain())) {
                    articleWP.setAuthor(auteur.getBjWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.BF.getSubdomain())) {
                    articleWP.setAuthor(auteur.getBfWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.CG.getSubdomain())) {
                    articleWP.setAuthor(auteur.getCgWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.CD.getSubdomain())) {
                    articleWP.setAuthor(auteur.getCdWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.CI.getSubdomain())) {
                    articleWP.setAuthor(auteur.getCiWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.CM.getSubdomain())) {
                    articleWP.setAuthor(auteur.getCmWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.FR.getSubdomain())) {
                    articleWP.setAuthor(auteur.getFrWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.GA.getSubdomain())) {
                    articleWP.setAuthor(auteur.getGaWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.GN.getSubdomain())) {
                    articleWP.setAuthor(auteur.getGnWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.MG.getSubdomain())) {
                    articleWP.setAuthor(auteur.getMgWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.ML.getSubdomain())) {
                    articleWP.setAuthor(auteur.getMlWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.MR.getSubdomain())) {
                    articleWP.setAuthor(auteur.getMrWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.NE.getSubdomain())) {
                    articleWP.setAuthor(auteur.getNeWordpressID());
                } else if (article.getSousdomaine().equals(SubdomainsPaysEnum.TG.getSubdomain())) {
                    articleWP.setAuthor(auteur.getTgWordpressID());
                }
                for (Categorie categorie : categories) {
                    if (!categorie.getName().equals(article.getCategorie())) continue;
                    articleWP.setCategories(categorie.getId());
                    break;
                }
                HttpEntity articleRequestEntity = new HttpEntity((Object)articleWP, (MultiValueMap)headers);
                String string = (String)this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/posts", HttpMethod.POST, articleRequestEntity, String.class, new Object[0]).getBody();
                Long id = Long.valueOf(string.split(",")[0].split(":")[1]);
                HttpHeaders headersfiles = new HttpHeaders();
                headersfiles.set("Authorization", authHeader);
                headersfiles.setContentType(MediaType.MULTIPART_FORM_DATA);
                String newFileName = article.getTitre() + ".jpeg";
                LinkedMultiValueMap body = new LinkedMultiValueMap();
                if (article.getImage() != null) {
                    File fileToUpload = new File("/home/speak2024/dev.speakyfree.com/Uploads/" + article.getImage());
                    1 fileSystemResource = new /* Unavailable Anonymous Inner Class!! */;
                    body.add((Object)"file", (Object)fileSystemResource);
                    body.add((Object)"post", (Object)id);
                    imageEntity = new HttpEntity((Object)body, (MultiValueMap)headersfiles);
                    responseEntity = this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/media", HttpMethod.POST, imageEntity, String.class, new Object[0]);
                }
                if (article.getAutresImages() != null) {
                    1 nomsImages;
                    for (1 file : nomsImages = article.getAutresImages().split("/")) {
                        File imageToUpload = new File("/home/speak2024/dev.speakyfree.com/Uploads/" + (String)file);
                        2 fileSystemResource1 = new /* Unavailable Anonymous Inner Class!! */;
                        body = new LinkedMultiValueMap();
                        body.add((Object)"file", (Object)fileSystemResource1);
                        body.add((Object)"post", (Object)id);
                        HttpEntity imageEntity2 = new HttpEntity((Object)body, (MultiValueMap)headersfiles);
                        ResponseEntity responseEntity2 = this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/media", HttpMethod.POST, imageEntity2, String.class, new Object[0]);
                    }
                }
                if (article.getVideo() != null) {
                    File videoToUpload = new File("/home/speak2024/dev.speakyfree.com/Uploads/" + article.getVideo());
                    3 fileSystemResourcevideo = new /* Unavailable Anonymous Inner Class!! */;
                    body = new LinkedMultiValueMap();
                    body.add((Object)"file", (Object)fileSystemResourcevideo);
                    body.add((Object)"post", (Object)id);
                    imageEntity = new HttpEntity((Object)body, (MultiValueMap)headersfiles);
                    responseEntity = this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/media", HttpMethod.POST, imageEntity, String.class, new Object[0]);
                }
                article.setWordpressID(id);
            }
            this.articleRepository.saveAllAndFlush((Iterable)articles);
        }
    }

    public void resizeImage(String inputImagePath, String outputImagePath) {
        try {
            File fileToDelete = new File(outputImagePath);
            if (fileToDelete.exists()) {
                fileToDelete.delete();
            }
            Thumbnails.of((String[])new String[]{inputImagePath}).size(82, 82).outputQuality(1.0).outputFormat("jpeg").toFile(outputImagePath);
            System.out.println("image resized to 82 x 82");
        }
        catch (IOException e) {
            System.out.println("IMAGE NOT RESIZED TO 82 x 82");
        }
    }

    public String getvideo(String videoname) throws IOException {
        return this.photoService.getVideo(videoname);
    }

    public String getaudio(String audioname) throws IOException {
        return this.photoService.getAudio(audioname);
    }

    public List<String> getAutresimagesbyArticle(Long id) throws IOException {
        Optional article = this.articleRepository.findById((Object)id);
        ArrayList<String> medias = new ArrayList<String>();
        if (article.isPresent() && ((Article)article.get()).getAutresImages() != null) {
            medias.addAll(this.photoService.getAllPhotos(((Article)article.get()).getAutresImages().split("/")));
        }
        return medias;
    }

    public List<Article> getAllArticles() {
        return this.articleRepository.findAll();
    }

    private long calculateContentLength(List<Article> list) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString(list);
        return jsonString.getBytes().length;
    }

    public ResponseEntity<List<Article>> getAllByActeurID(Long id) throws IOException {
        List articles = this.articleRepository.findByAuteurIDOrderByDateCreationDesc(id);
        for (int i = 0; i < articles.size(); ++i) {
            if (((Article)articles.get(i)).getImage82() != null) {
                ((Article)articles.get(i)).setImage82(this.photoService.getPhoto82(((Article)articles.get(i)).getImage82()));
            }
            ((Article)articles.get(i)).setContenu("");
        }
        long contentLength = this.calculateContentLength(articles);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articles);
    }

    public ResponseEntity<List<Article>> getAllByActeurIDAndStatus(Long id, String status) throws IOException {
        List articles = this.articleRepository.findByAuteurIDAndStatusOrderByDateCreationDesc(id, status);
        for (Article article : articles) {
            article.setContenu("");
        }
        long contentLength = this.calculateContentLength(articles);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articles);
    }

    public ResponseEntity<ArticleDto> getArticleByID(Long id) throws IOException {
        Optional article = this.articleRepository.findById((Object)id);
        if (article.isPresent()) {
            ArticleDto articleDto = new ArticleDto();
            ((Article)article.get()).setImage(this.photoService.getPhoto(((Article)article.get()).getImage()));
            articleDto.setArticle((Article)article.get());
            if (((Article)article.get()).getAutresImages() != null) {
                articleDto.setAutresimags(this.photoService.getAllPhotos(((Article)article.get()).getAutresImages().split("/")));
            }
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString((Object)articleDto);
            long contentLength = jsonString.getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articleDto);
        }
        return null;
    }

    @Transactional
    public Article AddArticle(MultipartFile file, Optional<MultipartFile[]> files, Optional<MultipartFile> audioVideo, String article) throws JsonProcessingException {
        Article article1 = (Article)new ObjectMapper().readValue(article, Article.class);
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String dateString = format.format(new Date());
        article1.setDateCreation(new Date());
        article1.setPageViews(Long.valueOf(0L));
        article1.setAreactiver(Boolean.valueOf(false));
        article1.setAdesactiver(Boolean.valueOf(false));
        try {
            String extension = "";
            extension = file.getContentType() != null ? file.getContentType().split("/")[1] : "jpeg";
            String filename = "article-" + article1.getAuteurID() + "-" + dateString + "." + extension;
            Files.copy(file.getInputStream(), this.root.resolve(filename), new CopyOption[0]);
            this.resizeImage("/home/speak2024/dev.speakyfree.com/Uploads/" + filename, "/home/speak2024/dev.speakyfree.com/Uploads82/" + filename);
            article1.setImage(filename);
            article1.setImage82(filename);
            if (files.isPresent()) {
                String autresFilenames = "";
                for (int i = 0; i < files.get().length; ++i) {
                    String filenamee = "article-" + i + "-" + article1.getAuteurID() + "-" + dateString + "." + files.get()[i].getContentType().split("/")[1];
                    Files.copy(files.get()[i].getInputStream(), this.root.resolve(filenamee), new CopyOption[0]);
                    this.resizeImage("/home/speak2024/dev.speakyfree.com/Uploads/" + filenamee, "/home/speak2024/dev.speakyfree.com/Uploads82/" + filenamee);
                    autresFilenames = autresFilenames + filenamee + "/";
                }
                article1.setAutresImages(autresFilenames);
                article1.setAutresImages82(autresFilenames);
            }
            if (audioVideo.isPresent() && audioVideo.get().getContentType() != null) {
                String audioOuVideoname;
                if (audioVideo.get().getContentType().split("/")[0].equals("audio")) {
                    audioOuVideoname = "audio-" + article1.getAuteurID() + "-" + dateString + "." + audioVideo.get().getContentType().split("/")[1];
                    Files.copy(audioVideo.get().getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                    article1.setAudio(audioOuVideoname);
                } else if (audioVideo.get().getContentType().split("/")[0].equals("video")) {
                    audioOuVideoname = "video-" + article1.getAuteurID() + "-" + dateString + ".mp4";
                    Files.copy(audioVideo.get().getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                    article1.setVideo(audioOuVideoname);
                }
            }
            return (Article)this.articleRepository.save((Object)article1);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not store the file . Error: " + e.getMessage());
        }
    }

    @Transactional
    public Article AddVideo(MultipartFile audioVideo, String article) throws JsonProcessingException {
        Article article1 = (Article)new ObjectMapper().readValue(article, Article.class);
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String dateString = format.format(new Date());
        article1.setDateCreation(new Date());
        try {
            String filename = "articleVideo-" + article1.getAuteurID() + "-" + dateString + "." + audioVideo.getContentType().split("/")[1];
            Files.copy(audioVideo.getInputStream(), this.root.resolve(filename), new CopyOption[0]);
            if (audioVideo.getContentType().split("/")[0].equals("audio")) {
                String audioOuVideoname = "audio-" + article1.getAuteurID() + "-" + dateString + "." + audioVideo.getContentType().split("/")[1];
                Files.copy(audioVideo.getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                article1.setAudio(audioOuVideoname);
            } else if (audioVideo.getContentType().split("/")[0].equals("video")) {
                String audioOuVideoname = "video-" + article1.getAuteurID() + "-" + dateString + ".mp4";
                Files.copy(audioVideo.getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                article1.setVideo(audioOuVideoname);
            }
            return (Article)this.articleRepository.save((Object)article1);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not store the file . Error: " + e.getMessage());
        }
    }

    @Transactional
    public Article ModifierArticle(Optional<MultipartFile> file, Optional<MultipartFile[]> files, Optional<MultipartFile> audioVideo, String newarticle) throws JsonProcessingException {
        Article article = (Article)new ObjectMapper().readValue(newarticle, Article.class);
        Article article1 = (Article)this.articleRepository.findById((Object)article.getId()).get();
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String dateString = format.format(new Date());
        try {
            if (file.isPresent()) {
                Files.deleteIfExists(this.root.resolve(article1.getImage()));
                String filename = "article-" + article1.getAuteurID() + "-" + dateString + "." + file.get().getContentType().split("/")[1];
                Files.copy(file.get().getInputStream(), this.root.resolve(filename), new CopyOption[0]);
                article1.setImage(filename);
            }
            if (files.isPresent()) {
                if (article.getAutresImages() != null) {
                    this.photoService.deleteAllPhotos(article1.getAutresImages().split("/"));
                }
                String autresFilenames = "";
                for (int i = 0; i < files.get().length; ++i) {
                    String filenamee = "article-" + i + "-" + article1.getAuteurID() + "-" + dateString + "." + files.get()[i].getContentType().split("/")[1];
                    Files.copy(files.get()[i].getInputStream(), this.root.resolve(filenamee), new CopyOption[0]);
                    autresFilenames = autresFilenames + filenamee + "/";
                }
                article1.setAutresImages(autresFilenames);
            }
            if (audioVideo.isPresent()) {
                if (article1.getVideo() != null) {
                    Files.deleteIfExists(this.root.resolve(article1.getVideo()));
                }
                if (article1.getAudio() != null) {
                    Files.deleteIfExists(this.root.resolve(article1.getAudio()));
                }
                String audioOuVideoname = "audioOuVideo-" + article1.getAuteurID() + "-" + dateString + "." + audioVideo.get().getContentType().split("/")[1];
                Files.copy(audioVideo.get().getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                if (audioVideo.get().getContentType().split("/")[0].equals("audio")) {
                    article1.setAudio(audioOuVideoname);
                } else if (audioVideo.get().getContentType().split("/")[0].equals("video")) {
                    article1.setVideo(audioOuVideoname);
                }
            }
            article1.setAnonymat(article.getAnonymat());
            article1.setApercu(article.getApercu());
            article1.setContenu(article.getContenu());
            article1.setCategorie(article.getCategorie());
            article1.setLienyoutube(article.getLienyoutube());
            article1.setTitre(article.getTitre());
            article1.setPseudoauteur(article.getPseudoauteur());
            article1.setStatus(article.getStatus());
            article1.setWordpressID(article.getWordpressID());
            return (Article)this.articleRepository.save((Object)article1);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not store the file . Error: " + e.getMessage());
        }
    }

    @Transactional
    public Article ModifyArticle(Optional<MultipartFile> file, Optional<String> files, Optional<MultipartFile> audioVideo, String newarticle) throws JsonProcessingException {
        Article article = (Article)new ObjectMapper().readValue(newarticle, Article.class);
        Article article1 = (Article)this.articleRepository.findById((Object)article.getId()).get();
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String dateString = format.format(new Date());
        try {
            if (file.isPresent()) {
                Files.deleteIfExists(this.root.resolve(article1.getImage()));
                new File("/home/speak2024/dev.speakyfree.com/Uploads82/" + article1.getImage82()).delete();
                String filename = "article-" + article1.getAuteurID() + "-" + dateString + "." + file.get().getContentType().split("/")[1];
                Files.copy(file.get().getInputStream(), this.root.resolve(filename), new CopyOption[0]);
                this.resizeImage("/home/speak2024/dev.speakyfree.com/Uploads/" + filename, "/home/speak2024/dev.speakyfree.com/Uploads82/" + filename);
                article1.setImage(filename);
                article1.setImage82(filename);
            }
            if (files.isPresent()) {
                if (article.getAutresImages() != null) {
                    this.photoService.deleteAllPhotos(article1.getAutresImages().split("/"));
                }
                String autresFilenames = this.photoService.SaveFiles(Arrays.asList(files.get().split("@")), article1.getAuteurID());
                article1.setAutresImages(autresFilenames);
                article1.setAutresImages82(autresFilenames);
            } else {
                article1.setAutresImages82(null);
                article1.setAutresImages(null);
            }
            if (audioVideo.isPresent()) {
                String audioOuVideoname;
                if (article1.getVideo() != null) {
                    Files.deleteIfExists(this.root.resolve(article1.getVideo()));
                }
                if (article1.getAudio() != null) {
                    Files.deleteIfExists(this.root.resolve(article1.getAudio()));
                }
                if (audioVideo.get().getContentType().split("/")[0].equals("audio")) {
                    audioOuVideoname = "audio-" + article1.getAuteurID() + "-" + dateString + "." + audioVideo.get().getContentType().split("/")[1];
                    Files.copy(audioVideo.get().getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                    article1.setAudio(audioOuVideoname);
                } else if (audioVideo.get().getContentType().split("/")[0].equals("video")) {
                    audioOuVideoname = "video-" + article1.getAuteurID() + "-" + dateString + ".mp4";
                    Files.copy(audioVideo.get().getInputStream(), this.root.resolve(audioOuVideoname), new CopyOption[0]);
                    article1.setVideo(audioOuVideoname);
                }
            } else if (article.getVideo() != null && article.getVideo().equals("asupprimer")) {
                Files.deleteIfExists(this.root.resolve(article1.getVideo()));
                article1.setVideo(null);
            }
            article1.setSousdomaine(article.getSousdomaine());
            article1.setAnonymat(article.getAnonymat());
            article1.setApercu(article.getApercu());
            article1.setContenu(article.getContenu());
            article1.setCategorie(article.getCategorie());
            article1.setLienyoutube(article.getLienyoutube());
            article1.setTitre(article.getTitre());
            article1.setPseudoauteur(article.getPseudoauteur());
            article1.setStatus(article.getStatus());
            article1.setWordpressID(article.getWordpressID());
            article1.setDatemodification(new Date());
            return (Article)this.articleRepository.save((Object)article1);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not store the file . Error: " + e.getMessage());
        }
    }

    @Transactional
    public Article UpdateStatus(Long id, String status) {
        Article article = (Article)this.articleRepository.findById((Object)id).get();
        article.setStatus(status);
        return (Article)this.articleRepository.save((Object)article);
    }

    @Transactional
    public String deleteArticle(Long id) {
        Article article = (Article)this.articleRepository.findById((Object)id).get();
        try {
            Files.deleteIfExists(this.root.resolve(article.getImage()));
            if (article.getVideo() != null) {
                Files.deleteIfExists(this.root.resolve(article.getVideo()));
            }
            if (article.getAudio() != null) {
                Files.deleteIfExists(this.root.resolve(article.getAudio()));
            }
            if (article.getAutresImages() != null) {
                this.photoService.deleteAllPhotos(article.getAutresImages().split("/"));
            }
            this.articleRepository.deleteById((Object)id);
            return "Article supprim\u00e9 !!!";
        }
        catch (IOException e) {
            throw new RuntimeException("Could not delete the file . Error: " + e.getMessage());
        }
    }

    @Transactional
    public String deleteArticles(List<Long> ids) {
        List articles = this.articleRepository.findAllById(ids);
        try {
            for (int i = 0; i < articles.size(); ++i) {
                Files.deleteIfExists(this.root.resolve(((Article)articles.get(i)).getImage()));
                if (((Article)articles.get(i)).getVideo() != null) {
                    Files.deleteIfExists(this.root.resolve(((Article)articles.get(i)).getVideo()));
                }
                if (((Article)articles.get(i)).getAudio() != null) {
                    Files.deleteIfExists(this.root.resolve(((Article)articles.get(i)).getAudio()));
                }
                if (((Article)articles.get(i)).getAutresImages() == null) continue;
                this.photoService.deleteAllPhotos(((Article)articles.get(i)).getAutresImages().split("/"));
            }
            this.articleRepository.deleteAllById(ids);
            return "Articles supprim\u00e9s !!!";
        }
        catch (IOException e) {
            throw new RuntimeException("Could not delete the file . Error: " + e.getMessage());
        }
    }
}

