/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.dto.StatcounterPageStats;
import com.notrecontinent.webapi.dto.Statistiques;
import com.notrecontinent.webapi.entities.Article;
import com.notrecontinent.webapi.entities.Statistique;
import com.notrecontinent.webapi.repositories.ArticleRepository;
import com.notrecontinent.webapi.repositories.StatistiqueRepository;
import com.notrecontinent.webapi.services.PhotoService;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
public class StatistiquesService {
    @Autowired
    private ArticleRepository articleRepository;
    @Autowired
    private PhotoService photoService;
    @Autowired
    private StatistiqueRepository statistiqueRepository;
    @Autowired
    private RestTemplate restTemplate;
    private String Username = "notrecontinent";
    private String APIPassword = "Di@m@l@ye1995@!!!!&&&@###";
    private String projectID = "12854953";
    String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    public List<Statistique> getStatcounterStatsForTests() throws JsonProcessingException {
        return this.statistiqueRepository.findAll();
    }

    private long calculateContentLength(List<Article> list) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString(list);
        return jsonString.getBytes().length;
    }

    public ResponseEntity<List<Article>> getStatistiquesByAuteurID(Long id) throws IOException {
        List articles = this.articleRepository.findByAuteurIDAndStatusOrderByDateCreationDesc(id, "Valid\u00e9 (en ligne)");
        if (!articles.isEmpty()) {
            for (Article article : articles) {
                if (article.getImage82() == null) continue;
                article.setImage82(this.photoService.getPhoto82(article.getImage82()));
            }
        }
        long contentLength = this.calculateContentLength(articles);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articles);
    }

    @Scheduled(cron="0 0 1 * * *", zone="GMT")
    @Transactional
    public void ReloadStatistiques() throws JsonProcessingException {
        List articles = this.articleRepository.findByStatus("Valid\u00e9 (en ligne)");
        if (!articles.isEmpty()) {
            LocalDate todayDate = LocalDate.now();
            String todaytoString = todayDate.minusDays(1L).toString();
            String day = todaytoString.split("-")[2];
            String month = todaytoString.split("-")[1];
            String year = todaytoString.split("-")[0];
            String granularity = "&g=daily&sd=" + day + "&sm=" + month + "&sy=" + year + "&ed=" + day + "&em=" + month + "&ey=" + year;
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String t = String.valueOf(timestamp.getTime() / 1000L);
            String sha1String = "";
            String finalUrl = "";
            int nbResults = 99999;
            String QueryStringUrlWithoutPwd = "?vn=3&s=popular" + granularity + "&f=json&pi=" + this.projectID + "&n=" + nbResults + "&t=" + t + "&u=" + this.Username;
            String QueryStringUrl = "?vn=3&s=popular" + granularity + "&f=json&pi=" + this.projectID + "&n=" + nbResults + "&t=" + t + "&u=" + this.Username + this.APIPassword;
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                byte[] messageDigest = md.digest(QueryStringUrl.getBytes());
                BigInteger no = new BigInteger(1, messageDigest);
                sha1String = no.toString(16);
                while (sha1String.length() < 32) {
                    sha1String = "0" + sha1String;
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            finalUrl = "https://api.statcounter.com/stats/" + QueryStringUrlWithoutPwd + "&sha1=" + sha1String;
            String stats = (String)this.restTemplate.getForObject(finalUrl, String.class, new Object[0]);
            String statsString = stats.substring(41, stats.length() - 1);
            ObjectMapper objectMapper = new ObjectMapper();
            StatcounterPageStats[] statcounterPageStats = (StatcounterPageStats[])objectMapper.readValue(statsString, StatcounterPageStats[].class);
            List<StatcounterPageStats> statsList = Arrays.asList(statcounterPageStats);
            block3: for (Article article : articles) {
                for (StatcounterPageStats stat : statsList) {
                    if (!article.getLink().equals(stat.getUrl()) || Long.valueOf(stat.getPage_views()) <= 0L) continue;
                    String newValue = stat.getPage_views();
                    int nb = Integer.parseInt(newValue);
                    if (0 <= nb && nb <= 50) {
                        newValue = String.valueOf(Math.round(nb * 9));
                    } else if (nb >= 51 && nb <= 100) {
                        newValue = String.valueOf(Math.round(nb * 6));
                    } else if (nb >= 101 && nb <= 200) {
                        newValue = String.valueOf(Math.round(nb * 4));
                    } else if (nb >= 201 && nb <= 500) {
                        newValue = String.valueOf(Math.round(nb * 2));
                    } else if (nb >= 501 && nb <= 1000) {
                        newValue = String.valueOf(Math.round((double)nb * 1.5));
                    } else if (nb >= 1000) {
                        newValue = String.valueOf(Math.round(nb));
                    }
                    Random random = new Random();
                    int randomNumber = random.nextInt(9) + 1;
                    article.setPageViews(Long.valueOf(article.getPageViews() + Long.valueOf(newValue) + (long)randomNumber));
                    article.setDateDerniereVue(new Date());
                    continue block3;
                }
            }
            this.articleRepository.saveAllAndFlush((Iterable)articles);
        }
    }

    public String cutstring(String str, int n) {
        return str.substring(0, str.length() - n);
    }

    public List<Statistiques> getAuteurStatistiques(Long auteurID) {
        List articleList = this.articleRepository.findByAuteurIDAndStatus(auteurID, "Valid\u00e9 (en ligne)");
        ArrayList<Statistiques> statistiques = new ArrayList<Statistiques>();
        if (articleList.size() > 0) {
            for (Article article : articleList) {
                Statistiques statistique = new Statistiques();
                statistique.setPageTitle(article.getTitre());
                statistique.setPageUrl(article.getLink());
                statistique.setPageViews(article.getPageViews());
                statistiques.add(statistique);
            }
        }
        return statistiques;
    }

    public List<StatcounterPageStats> getAllStatistiques() throws JsonProcessingException {
        LocalDate todayDate = LocalDate.now();
        String todaytoString = todayDate.minusDays(1L).toString();
        String day = todaytoString.split("-")[2];
        String month = todaytoString.split("-")[1];
        String year = todaytoString.split("-")[0];
        String granularity = "&g=daily&sd=" + day + "&sm=" + month + "&sy=" + year + "&ed=" + day + "&em=" + month + "&ey=" + year;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String t = String.valueOf(timestamp.getTime() / 1000L);
        String sha1String = "";
        String finalUrl = "";
        int nbResults = 99999;
        String QueryStringUrlWithoutPwd = "?vn=3&s=popular" + granularity + "&f=json&pi=" + this.projectID + "&n=" + nbResults + "&t=" + t + "&u=" + this.Username;
        String QueryStringUrl = "?vn=3&s=popular" + granularity + "&f=json&pi=" + this.projectID + "&n=" + nbResults + "&t=" + t + "&u=" + this.Username + this.APIPassword;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] messageDigest = md.digest(QueryStringUrl.getBytes());
            BigInteger no = new BigInteger(1, messageDigest);
            sha1String = no.toString(16);
            while (sha1String.length() < 32) {
                sha1String = "0" + sha1String;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        finalUrl = "https://api.statcounter.com/stats/" + QueryStringUrlWithoutPwd + "&sha1=" + sha1String;
        String stats = (String)this.restTemplate.getForObject(finalUrl, String.class, new Object[0]);
        String statsString = stats.substring(41, stats.length() - 1);
        System.out.println("------------------");
        System.out.println(statsString);
        System.out.println("------------------");
        ObjectMapper objectMapper = new ObjectMapper();
        StatcounterPageStats[] statcounterPageStats = (StatcounterPageStats[])objectMapper.readValue(statsString, StatcounterPageStats[].class);
        List<StatcounterPageStats> statsList = Arrays.asList(statcounterPageStats);
        return statsList;
    }
}

