/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.dto.ArticleWordpress;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Categorie;
import com.notrecontinent.webapi.entities.Recommandation;
import com.notrecontinent.webapi.mapstruct.CategorieMapper;
import com.notrecontinent.webapi.mapstruct.RecommandationMapper;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import com.notrecontinent.webapi.services.BugsCronService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
public class CronRecommandationJourService {
    @Value(value="${parametre.lien.recommandation}")
    private Long param;
    @Autowired
    private RecommandationMapper recommandationMapper;
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private CategorieMapper categorieMapper;

    public void SelectionnerArticleM\u00e9t\u00e9o(int heure) {
        List amis = this.auteurRepository.findBycentresdinteretsContainingElement("M\u00e9t\u00e9o");
        if (!amis.isEmpty()) {
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Categorie categorie : categories) {
                if (!categorie.getName().equals("M\u00e9t\u00e9o")) continue;
                idCategorie = categorie.getId();
                break;
            }
            String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date&status=publish&categories=" + idCategorie + "&orderby=date&order=desc&per_page=1";
            ResponseEntity responseEntity = this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]);
            String lien = ((ArticleWordpress[])responseEntity.getBody())[0].getLink();
            String titre = ((ArticleWordpress[])responseEntity.getBody())[0].getTitle().getRendered().replace("&rsquo;", "'").replace("&#8217;", "'");
            System.out.println("Article M\u00e9t\u00e9o : " + titre);
            System.out.println("Lien article M\u00e9t\u00e9o : " + lien);
            LocalDateTime gmtDateTime = LocalDateTime.now(ZoneOffset.UTC);
            LocalDateTime gmtDateTime2Compare = gmtDateTime.minusHours(3L).withHour(heure).withMinute(0).withSecond(0);
            String inputDateTime = ((ArticleWordpress[])responseEntity.getBody())[0].getDate();
            DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
            LocalDateTime dateTime = LocalDateTime.parse(inputDateTime, inputFormatter);
            DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
            String outputDateTime = dateTime.format(outputFormatter);
            LocalDateTime dateMeteo = LocalDateTime.parse(outputDateTime, outputFormatter);
            Boolean b = dateMeteo.isAfter(gmtDateTime2Compare);
            if (b.booleanValue()) {
                for (Auteur ami : amis) {
                    if (this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(lien, ami.getId()) != null) continue;
                    Recommandation recommandation1 = this.recommandationRepository.findByParametre(this.param);
                    if (recommandation1 != null) {
                        Recommandation recommandation2 = this.recommandationRepository.findFirstByOrderByIdDesc();
                        this.param = recommandation2.getParametre() + 1L;
                    }
                    String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                    lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                    lienRecommandation = lienRecommandation + this.param;
                    Recommandation recommandation = new Recommandation();
                    recommandation.setParametre(this.param);
                    recommandation.setCategoriearticle("M\u00e9t\u00e9o");
                    recommandation.setLienrecommandation(lienRecommandation);
                    recommandation.setAuteurid(ami.getId());
                    recommandation.setEstenvoyer(Boolean.valueOf(false));
                    recommandation.setEstcliquer(Boolean.valueOf(false));
                    recommandation.setLienarticle(lien);
                    recommandation.setTitrearticle(titre);
                    recommandation.setNomami(ami.getFirst_name());
                    if (ami.getCreerpar().equals("email") && ami.getTelephone() != null && !ami.getTelephone().equals("")) {
                        if (ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) {
                            recommandation.setCompte(ami.getEmail());
                            if (ami.getMessagesEmail().booleanValue()) {
                                recommandation.setEstenvoyerpar("email");
                            }
                        } else if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                            recommandation.setCompte(ami.getNumwhatsapp());
                            if (ami.getMessagesWhatsapp().booleanValue()) {
                                recommandation.setEstenvoyerpar("WhatsApp");
                            }
                        }
                    } else if (ami.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                        if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                            recommandation.setCompte(ami.getNumwhatsapp());
                            if (ami.getMessagesWhatsapp().booleanValue()) {
                                recommandation.setEstenvoyerpar("WhatsApp");
                            }
                        } else if (!(ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("") || ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                            recommandation.setCompte(ami.getEmail());
                            if (ami.getMessagesEmail().booleanValue()) {
                                recommandation.setEstenvoyerpar("email");
                            }
                        } else if ((ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) && (ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                            recommandation.setCompte(ami.getUsername());
                        }
                    }
                    recommandation.setNumrecommandation(Long.valueOf(6L));
                    this.recommandationRepository.save((Object)recommandation);
                    this.param = this.param + 1L;
                }
            }
        }
    }

    @Transactional
    public void SelectionnerArticleM\u00e9t\u00e9o1() {
        this.SelectionnerArticleM\u00e9t\u00e9o(20);
    }

    @Transactional
    public void SelectionnerArticleM\u00e9t\u00e9o2() throws ParseException {
        List IdsAmis = this.auteurRepository.findIdAmisBycentresdinteretsContainingElement("M\u00e9t\u00e9o");
        if (!IdsAmis.isEmpty()) {
            DateTimeFormatter outputFormatter;
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            LocalDateTime gmtDateTime = LocalDateTime.now(ZoneOffset.UTC);
            LocalDateTime gmtDateTime2Compare = gmtDateTime.minusHours(3L).withHour(22).withMinute(44).withSecond(0);
            String outputDateTime = gmtDateTime2Compare.format(outputFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss"));
            Date gmtDate2Compare = sdf.parse(outputDateTime);
            List recommandations = this.recommandationRepository.findByCategoriearticleAndDateCreationGreaterThan("M\u00e9t\u00e9o", gmtDate2Compare);
            if (!recommandations.isEmpty()) {
                ArrayList<Long> amisIdsrec = new ArrayList<Long>();
                for (Recommandation recommandation : recommandations) {
                    amisIdsrec.add(recommandation.getAuteurid());
                }
                List difference = IdsAmis.stream().filter(element -> !amisIdsrec.contains(element)).collect(Collectors.toList());
                if (!difference.isEmpty()) {
                    this.SelectionnerArticleM\u00e9t\u00e9o(21);
                }
            } else {
                this.SelectionnerArticleM\u00e9t\u00e9o(21);
            }
        }
    }

    @Transactional
    public void SelectionnerArticleM\u00e9t\u00e9o3() {
        try {
            List IdsAmis = this.auteurRepository.findIdAmisBycentresdinteretsContainingElement("M\u00e9t\u00e9o");
            if (!IdsAmis.isEmpty()) {
                DateTimeFormatter outputFormatter;
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                LocalDateTime gmtDateTime = LocalDateTime.now(ZoneOffset.UTC);
                LocalDateTime gmtDateTime2Compare = gmtDateTime.minusHours(3L).withHour(22).withMinute(44).withSecond(0);
                String outputDateTime = gmtDateTime2Compare.format(outputFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss"));
                Date gmtDate2Compare = sdf.parse(outputDateTime);
                List recommandations = this.recommandationRepository.findByCategoriearticleAndDateCreationGreaterThan("M\u00e9t\u00e9o", gmtDate2Compare);
                if (!recommandations.isEmpty()) {
                    ArrayList<Long> amisIdsrec = new ArrayList<Long>();
                    for (Recommandation recommandation : recommandations) {
                        amisIdsrec.add(recommandation.getAuteurid());
                    }
                    List difference = IdsAmis.stream().filter(element -> !amisIdsrec.contains(element)).collect(Collectors.toList());
                    if (!difference.isEmpty()) {
                        this.SelectionnerArticleM\u00e9t\u00e9o(22);
                    }
                } else {
                    this.SelectionnerArticleM\u00e9t\u00e9o(22);
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de la 3\u00e8me s\u00e9lection de M\u00e9t\u00e9o", e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reSelectionnerPremierenvoi(List<Auteur> amis) {
        if (!amis.isEmpty()) {
            LocalDateTime gmtDateTime = LocalDateTime.now(ZoneOffset.UTC);
            LocalDateTime gmtDateTime2Compare = gmtDateTime.minusDays(1L).withHour(17).withMinute(0).withSecond(0);
            DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
            String outputDateTime = gmtDateTime2Compare.format(outputFormatter);
            System.out.println("date de 17h : " + outputDateTime);
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            for (Auteur ami : amis) {
                void var15_27;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                System.out.println("centres d'int\u00e9r\u00eats : " + centredinterets);
                String categoriesAmi = "";
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        if (i < centredinterets.size() - 1) {
                            categoriesAmi = categoriesAmi + categorie.getId() + ",";
                            continue;
                        }
                        categoriesAmi = categoriesAmi + categorie.getId();
                    }
                }
                System.out.println("centres d'int\u00e9r\u00eats ids: " + categoriesAmi);
                String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + categoriesAmi + "&after=" + outputDateTime + "&orderby=date&order=desc&per_page=50";
                ArticleWordpress[] response = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                List<ArticleWordpress> list = Arrays.asList(response);
                System.out.println("taille articles : " + list.size());
                for (ArticleWordpress articleWordpress : list) {
                    System.out.println(articleWordpress.getLink());
                    System.out.println(articleWordpress.getTitle().getRendered());
                }
                List list2 = list.stream().filter(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) == null).collect(Collectors.toList());
                System.out.println("Fin");
                if (list2.isEmpty()) continue;
                String categorieArticle = "";
                ArticleWordpress articleWordpress = new ArticleWordpress();
                if (centredinterets.contains("Horoscope")) {
                    void var15_23;
                    Long idCatHoroscope = 1L;
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals("Horoscope")) continue;
                        idCatHoroscope = categorie.getId();
                        break;
                    }
                    for (ArticleWordpress articleWordpress2 : list2) {
                        if (!Arrays.asList(articleWordpress2.getCategories()).contains(idCatHoroscope)) continue;
                        ArticleWordpress articleWordpress3 = articleWordpress2;
                        categorieArticle = "Horoscope";
                        System.out.println("horoscope existe");
                        System.out.println(articleWordpress3.getLink());
                        System.out.println(articleWordpress3.getTitle().getRendered());
                        System.out.println(categorieArticle);
                        break;
                    }
                    if (var15_23.equals(new ArticleWordpress())) {
                        int i = 0;
                        LocalDateTime localDateTime = LocalDateTime.parse(((ArticleWordpress)list2.get(0)).getDate());
                        for (ArticleWordpress articleWordpress4 : list2) {
                            void var18_41;
                            LocalDateTime currentDate = LocalDateTime.parse(articleWordpress4.getDate());
                            if (!currentDate.isAfter((ChronoLocalDateTime<?>)var18_41)) continue;
                            LocalDateTime localDateTime2 = currentDate;
                            i = list2.indexOf(articleWordpress4);
                        }
                        ArticleWordpress articleWordpress5 = (ArticleWordpress)list2.get(i);
                        for (Categorie categorie : categories) {
                            if (!Objects.equals(categorie.getId(), articleWordpress5.getCategories()[0])) continue;
                            System.out.println(categorie.getName());
                            categorieArticle = categorie.getName();
                            break;
                        }
                        System.out.println("pas de horoscope");
                        System.out.println(articleWordpress5.getLink());
                        System.out.println(articleWordpress5.getTitle().getRendered());
                        System.out.println(categorieArticle);
                    }
                } else {
                    int i = 0;
                    LocalDateTime latestDate = LocalDateTime.parse(((ArticleWordpress)list2.get(0)).getDate());
                    for (ArticleWordpress articleWordpress6 : list2) {
                        LocalDateTime localDateTime = LocalDateTime.parse(articleWordpress6.getDate());
                        if (!localDateTime.isAfter(latestDate)) continue;
                        latestDate = localDateTime;
                        i = list2.indexOf(articleWordpress6);
                    }
                    ArticleWordpress articleWordpress7 = (ArticleWordpress)list2.get(i);
                    for (Categorie categorie : categories) {
                        if (!Objects.equals(categorie.getId(), articleWordpress7.getCategories()[0])) continue;
                        System.out.println(categorie.getName());
                        categorieArticle = categorie.getName();
                        break;
                    }
                    System.out.println("pas de horoscope dans centres d'int\u00e9r\u00eats");
                    System.out.println(articleWordpress7.getLink());
                    System.out.println(articleWordpress7.getTitle().getRendered());
                    System.out.println(categorieArticle);
                }
                Recommandation recommandation = this.recommandationRepository.findByParametre(this.param);
                if (recommandation != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = var15_27.getLink();
                String string2 = var15_27.getTitle().getRendered().replace("&rsquo;", "'").replace("&#8211;", "-");
                string2 = string2.replace("&#8230;", "...").replace("&#8217;", "'");
                String string5 = "https://lk.notrecontinent.com/?p=";
                string5 = string5 + lien.split("notrecontinent.com/")[1];
                string5 = string5 + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(string5);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(string2);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getCreerpar().equals("email") && ami.getTelephone() != null && !ami.getTelephone().equals("")) {
                    if (ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    }
                } else if (ami.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    } else if (!(ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("") || ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if ((ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) && (ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getUsername());
                    }
                }
                recommandation2.setNumrecommandation(Long.valueOf(1L));
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void SelectionnerPremierEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            LocalDateTime gmtDateTime = LocalDateTime.now(ZoneOffset.UTC);
            LocalDateTime gmtDateTime2Compare = gmtDateTime.minusDays(1L).withHour(17).withMinute(0).withSecond(0);
            DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
            String outputDateTime = gmtDateTime2Compare.format(outputFormatter);
            System.out.println("date de 17h : " + outputDateTime);
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            for (Auteur ami : amis) {
                void var15_27;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                System.out.println("centres d'int\u00e9r\u00eats : " + centredinterets);
                String categoriesAmi = "";
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        if (i < centredinterets.size() - 1) {
                            categoriesAmi = categoriesAmi + categorie.getId() + ",";
                            continue;
                        }
                        categoriesAmi = categoriesAmi + categorie.getId();
                    }
                }
                System.out.println("centres d'int\u00e9r\u00eats ids: " + categoriesAmi);
                String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + categoriesAmi + "&after=" + outputDateTime + "&orderby=date&order=desc&per_page=50";
                ArticleWordpress[] response = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                List<ArticleWordpress> list = Arrays.asList(response);
                System.out.println("taille articles : " + list.size());
                for (ArticleWordpress articleWordpress : list) {
                    System.out.println(articleWordpress.getLink());
                    System.out.println(articleWordpress.getTitle().getRendered());
                }
                List list2 = list.stream().filter(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) == null).collect(Collectors.toList());
                System.out.println("Fin");
                if (list2.isEmpty()) continue;
                String categorieArticle = "";
                ArticleWordpress articleWordpress = new ArticleWordpress();
                if (centredinterets.contains("Horoscope")) {
                    void var15_23;
                    Long idCatHoroscope = 1L;
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals("Horoscope")) continue;
                        idCatHoroscope = categorie.getId();
                        break;
                    }
                    for (ArticleWordpress articleWordpress2 : list2) {
                        if (!Arrays.asList(articleWordpress2.getCategories()).contains(idCatHoroscope)) continue;
                        ArticleWordpress articleWordpress3 = articleWordpress2;
                        categorieArticle = "Horoscope";
                        System.out.println("horoscope existe");
                        System.out.println(articleWordpress3.getLink());
                        System.out.println(articleWordpress3.getTitle().getRendered());
                        System.out.println(categorieArticle);
                        break;
                    }
                    if (var15_23.equals(new ArticleWordpress())) {
                        int i = 0;
                        LocalDateTime localDateTime = LocalDateTime.parse(((ArticleWordpress)list2.get(0)).getDate());
                        for (ArticleWordpress articleWordpress4 : list2) {
                            void var18_41;
                            LocalDateTime currentDate = LocalDateTime.parse(articleWordpress4.getDate());
                            if (!currentDate.isAfter((ChronoLocalDateTime<?>)var18_41)) continue;
                            LocalDateTime localDateTime2 = currentDate;
                            i = list2.indexOf(articleWordpress4);
                        }
                        ArticleWordpress articleWordpress5 = (ArticleWordpress)list2.get(i);
                        for (Categorie categorie : categories) {
                            if (!Objects.equals(categorie.getId(), articleWordpress5.getCategories()[0])) continue;
                            System.out.println(categorie.getName());
                            categorieArticle = categorie.getName();
                            break;
                        }
                        System.out.println("pas de horoscope");
                        System.out.println(articleWordpress5.getLink());
                        System.out.println(articleWordpress5.getTitle().getRendered());
                        System.out.println(categorieArticle);
                    }
                } else {
                    int i = 0;
                    LocalDateTime latestDate = LocalDateTime.parse(((ArticleWordpress)list2.get(0)).getDate());
                    for (ArticleWordpress articleWordpress6 : list2) {
                        LocalDateTime localDateTime = LocalDateTime.parse(articleWordpress6.getDate());
                        if (!localDateTime.isAfter(latestDate)) continue;
                        latestDate = localDateTime;
                        i = list2.indexOf(articleWordpress6);
                    }
                    ArticleWordpress articleWordpress7 = (ArticleWordpress)list2.get(i);
                    for (Categorie categorie : categories) {
                        if (!Objects.equals(categorie.getId(), articleWordpress7.getCategories()[0])) continue;
                        System.out.println(categorie.getName());
                        categorieArticle = categorie.getName();
                        break;
                    }
                    System.out.println("pas de horoscope dans centres d'int\u00e9r\u00eats");
                    System.out.println(articleWordpress7.getLink());
                    System.out.println(articleWordpress7.getTitle().getRendered());
                    System.out.println(categorieArticle);
                }
                Recommandation recommandation = this.recommandationRepository.findByParametre(this.param);
                if (recommandation != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = var15_27.getLink();
                String string2 = var15_27.getTitle().getRendered().replace("&rsquo;", "'").replace("&#8211;", "-");
                string2 = string2.replace("&#8230;", "...").replace("&#8217;", "'");
                String string5 = "https://lk.notrecontinent.com/?p=";
                string5 = string5 + lien.split("notrecontinent.com/")[1];
                string5 = string5 + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(string5);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(string2);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getCreerpar().equals("email") && ami.getTelephone() != null && !ami.getTelephone().equals("")) {
                    if (ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    }
                } else if (ami.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    } else if (!(ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("") || ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if ((ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) && (ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getUsername());
                    }
                }
                recommandation2.setNumrecommandation(Long.valueOf(1L));
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    @Transactional
    public void RelancerSelectionnerPremierEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            List amisNonRecom;
            Date fin;
            LocalDateTime localDateTime;
            Date debut;
            List amisIdsRecom;
            List<Object> idsAmis = new ArrayList<Long>();
            for (Auteur ami : amis) {
                idsAmis.add(ami.getId());
            }
            if (!(idsAmis.isEmpty() || (amisIdsRecom = this.recommandationRepository.findAmisIdsByDateBetween(debut = Date.from((localDateTime = LocalDateTime.now()).withHour(5).withMinute(43).withSecond(0).atZone(ZoneId.of("GMT")).toInstant()), fin = Date.from(localDateTime.atZone(ZoneId.of("GMT")).toInstant()))).isEmpty() || (idsAmis = idsAmis.stream().filter(a -> !amisIdsRecom.contains(a)).collect(Collectors.toList())).isEmpty() || (amisNonRecom = this.auteurRepository.findAllById(idsAmis)).isEmpty())) {
                this.reSelectionnerPremierenvoi(amisNonRecom);
            }
        }
    }

    @Transactional
    public void RelancerEncoreSelectionnerPremierEnvoi() {
        this.RelancerSelectionnerPremierEnvoi();
    }

    @Transactional
    public void RelancerEncore2SelectionnerPremierEnvoi() {
        try {
            this.RelancerSelectionnerPremierEnvoi();
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de la 1\u00e8re s\u00e9lection de recommandation", e.getMessage());
        }
    }

    public void reSelectionnerSecondenvoi(List<Auteur> amis) {
        if (!amis.isEmpty()) {
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                Object articleWordpress122;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                String categoriesAmi = "";
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        if (i < centredinterets.size() - 1) {
                            categoriesAmi = categoriesAmi + categorie.getId() + ",";
                            continue;
                        }
                        categoriesAmi = categoriesAmi + categorie.getId();
                    }
                }
                String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + categoriesAmi + "&orderby=date&order=desc&per_page=5";
                ArticleWordpress[] response = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                List<ArticleWordpress> list = Arrays.asList(response);
                List list2 = list.stream().filter(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) == null).collect(Collectors.toList());
                if (list2.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime latestDate = LocalDateTime.parse(((ArticleWordpress)list2.get(0)).getDate());
                for (Object articleWordpress122 : list2) {
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress122.getDate());
                    if (!currentDate.isAfter(latestDate)) continue;
                    latestDate = currentDate;
                    i = list2.indexOf(articleWordpress122);
                }
                articleWordpress = (ArticleWordpress)list2.get(i);
                String categorieArticle = "";
                articleWordpress122 = categories.iterator();
                while (articleWordpress122.hasNext()) {
                    Categorie categorie = (Categorie)articleWordpress122.next();
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                titre = titre.replace("&#8230;", "...").replace("&#8211;", "-");
                titre = titre.replace("&#8217;", "'");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getCreerpar().equals("email") && ami.getTelephone() != null && !ami.getTelephone().equals("")) {
                    if (ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    }
                } else if (ami.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    } else if (!(ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("") || ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if ((ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) && (ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getUsername());
                    }
                }
                recommandation2.setNumrecommandation(Long.valueOf(2L));
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    @Transactional
    public void RelancerSelectionnerSecondEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            List amisNonRecom;
            Date fin;
            LocalDateTime localDateTime;
            Date debut;
            List amisIdsRecom;
            List<Object> idsAmis = new ArrayList<Long>();
            for (Auteur ami : amis) {
                idsAmis.add(ami.getId());
            }
            if (!(idsAmis.isEmpty() || (amisIdsRecom = this.recommandationRepository.findAmisIdsByDateBetween(debut = Date.from((localDateTime = LocalDateTime.now()).withHour(8).withMinute(33).withSecond(0).atZone(ZoneId.of("GMT")).toInstant()), fin = Date.from(localDateTime.atZone(ZoneId.of("GMT")).toInstant()))).isEmpty() || (idsAmis = idsAmis.stream().filter(a -> !amisIdsRecom.contains(a)).collect(Collectors.toList())).isEmpty() || (amisNonRecom = this.auteurRepository.findAllById(idsAmis)).isEmpty())) {
                this.reSelectionnerSecondenvoi(amisNonRecom);
            }
        }
    }

    @Transactional
    public void RelancerEncoreSelectionnerSecondEnvoi() {
        this.RelancerSelectionnerSecondEnvoi();
    }

    @Transactional
    public void RelancerEncre2SelectionnerSecondEnvoi() {
        try {
            this.RelancerSelectionnerSecondEnvoi();
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de la 2\u00e8me s\u00e9lection de recommandation", e.getMessage());
        }
    }

    @Transactional
    public void SelectionnerSecondEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                Object articleWordpress122;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                String categoriesAmi = "";
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        if (i < centredinterets.size() - 1) {
                            categoriesAmi = categoriesAmi + categorie.getId() + ",";
                            continue;
                        }
                        categoriesAmi = categoriesAmi + categorie.getId();
                    }
                }
                String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + categoriesAmi + "&orderby=date&order=desc&per_page=5";
                ArticleWordpress[] response = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                List<ArticleWordpress> list = Arrays.asList(response);
                List list2 = list.stream().filter(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) == null).collect(Collectors.toList());
                if (list2.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime latestDate = LocalDateTime.parse(((ArticleWordpress)list2.get(0)).getDate());
                for (Object articleWordpress122 : list2) {
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress122.getDate());
                    if (!currentDate.isAfter(latestDate)) continue;
                    latestDate = currentDate;
                    i = list2.indexOf(articleWordpress122);
                }
                articleWordpress = (ArticleWordpress)list2.get(i);
                String categorieArticle = "";
                articleWordpress122 = categories.iterator();
                while (articleWordpress122.hasNext()) {
                    Categorie categorie = (Categorie)articleWordpress122.next();
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                titre = titre.replace("&#8230;", "...").replace("&#8211;", "-");
                titre = titre.replace("&#8217;", "'");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getCreerpar().equals("email") && ami.getTelephone() != null && !ami.getTelephone().equals("")) {
                    if (ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    }
                } else if (ami.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    } else if (!(ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("") || ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if ((ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) && (ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getUsername());
                    }
                }
                recommandation2.setNumrecommandation(Long.valueOf(2L));
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void S\u00e9lectionnerTroisiemeEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                ArrayList<ArticleWordpress> articleWordpresses = new ArrayList<ArticleWordpress>();
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        idCategorie = categorie.getId();
                        break;
                    }
                    String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + idCategorie + "&per_page=3&orderby=date&order=desc";
                    ArticleWordpress[] articleWordpressArray = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                    articleWordpresses.addAll(Arrays.asList(articleWordpressArray));
                }
                articleWordpresses.removeIf(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) != null);
                if (articleWordpresses.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime localDateTime = LocalDateTime.parse(((ArticleWordpress)articleWordpresses.get(0)).getDate());
                for (ArticleWordpress articleWordpress2 : articleWordpresses) {
                    void var11_17;
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress2.getDate());
                    if (!currentDate.isAfter((ChronoLocalDateTime<?>)var11_17)) continue;
                    LocalDateTime localDateTime2 = currentDate;
                    i = articleWordpresses.indexOf(articleWordpress2);
                }
                articleWordpress = (ArticleWordpress)articleWordpresses.get(i);
                String categorieArticle = "";
                for (Categorie categorie : categories) {
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'").replace("&#8217;", "'");
                titre = titre.replace("&#8230;", "...").replace("&#8211;", "-");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getCreerpar().equals("email") && ami.getTelephone() != null && !ami.getTelephone().equals("")) {
                    if (ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    }
                } else if (ami.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    } else if (!(ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("") || ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if ((ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) && (ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getUsername());
                    }
                }
                recommandation2.setNumrecommandation(Long.valueOf(3L));
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    public void reSelectionnerTroisiemeenvoi(List<Auteur> amis) {
        if (!amis.isEmpty()) {
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                Object articleWordpress122;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                String categoriesAmi = "";
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        if (i < centredinterets.size() - 1) {
                            categoriesAmi = categoriesAmi + categorie.getId() + ",";
                            continue;
                        }
                        categoriesAmi = categoriesAmi + categorie.getId();
                    }
                }
                String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + categoriesAmi + "&orderby=date&order=desc&per_page=5";
                ArticleWordpress[] response = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                List<ArticleWordpress> list = Arrays.asList(response);
                List list2 = list.stream().filter(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) == null).collect(Collectors.toList());
                if (list2.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime latestDate = LocalDateTime.parse(((ArticleWordpress)list2.get(0)).getDate());
                for (Object articleWordpress122 : list2) {
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress122.getDate());
                    if (!currentDate.isAfter(latestDate)) continue;
                    latestDate = currentDate;
                    i = list2.indexOf(articleWordpress122);
                }
                articleWordpress = (ArticleWordpress)list2.get(i);
                String categorieArticle = "";
                articleWordpress122 = categories.iterator();
                while (articleWordpress122.hasNext()) {
                    Categorie categorie = (Categorie)articleWordpress122.next();
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                titre = titre.replace("&#8230;", "...");
                titre = titre.replace("&#8217;", "'").replace("&#8211;", "-");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getCreerpar().equals("email") && ami.getTelephone() != null && !ami.getTelephone().equals("")) {
                    if (ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    }
                } else if (ami.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    } else if (!(ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("") || ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if ((ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) && (ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getUsername());
                    }
                }
                recommandation2.setNumrecommandation(Long.valueOf(3L));
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    @Transactional
    public void RelancerSelectionnerTroisiemeEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            List amisNonRecom;
            Date fin;
            LocalDateTime localDateTime;
            Date debut;
            List amisIdsRecom;
            List<Object> idsAmis = new ArrayList<Long>();
            for (Auteur ami : amis) {
                idsAmis.add(ami.getId());
            }
            if (!(idsAmis.isEmpty() || (amisIdsRecom = this.recommandationRepository.findAmisIdsByDateBetween(debut = Date.from((localDateTime = LocalDateTime.now()).withHour(8).withMinute(33).withSecond(0).atZone(ZoneId.of("GMT")).toInstant()), fin = Date.from(localDateTime.atZone(ZoneId.of("GMT")).toInstant()))).isEmpty() || (idsAmis = idsAmis.stream().filter(a -> !amisIdsRecom.contains(a)).collect(Collectors.toList())).isEmpty() || (amisNonRecom = this.auteurRepository.findAllById(idsAmis)).isEmpty())) {
                this.reSelectionnerTroisiemeenvoi(amisNonRecom);
            }
        }
    }

    @Transactional
    public void RelancerEncoreSelectionnerTroisiemeEnvoi() {
        this.RelancerSelectionnerTroisiemeEnvoi();
    }

    @Transactional
    public void RelancerEncre2SelectionnerTroisiemeEnvoi() {
        try {
            this.RelancerSelectionnerTroisiemeEnvoi();
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de la 3\u00e8me s\u00e9lection de recommandation", e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void S\u00e9lectionnerQuatriemeEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                ArrayList<ArticleWordpress> articleWordpresses = new ArrayList<ArticleWordpress>();
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        idCategorie = categorie.getId();
                        break;
                    }
                    String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + idCategorie + "&per_page=3&orderby=date&order=desc";
                    ArticleWordpress[] articleWordpressArray = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                    articleWordpresses.addAll(Arrays.asList(articleWordpressArray));
                }
                articleWordpresses.removeIf(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) != null);
                if (articleWordpresses.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime localDateTime = LocalDateTime.parse(((ArticleWordpress)articleWordpresses.get(0)).getDate());
                for (ArticleWordpress articleWordpress2 : articleWordpresses) {
                    void var11_17;
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress2.getDate());
                    if (!currentDate.isAfter((ChronoLocalDateTime<?>)var11_17)) continue;
                    LocalDateTime localDateTime2 = currentDate;
                    i = articleWordpresses.indexOf(articleWordpress2);
                }
                articleWordpress = (ArticleWordpress)articleWordpresses.get(i);
                String categorieArticle = "";
                for (Categorie categorie : categories) {
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                titre = titre.replace("&#8230;", "...").replace("&#8211;", "-").replace("&#8217;", "'");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getCreerpar().equals("email") && ami.getTelephone() != null && !ami.getTelephone().equals("")) {
                    if (ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    }
                } else if (ami.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    } else if (!(ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("") || ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if ((ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) && (ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getUsername());
                    }
                }
                recommandation2.setNumrecommandation(Long.valueOf(4L));
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    public void reSelectionnerQuatriemeenvoi(List<Auteur> amis) {
        if (!amis.isEmpty()) {
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                Object articleWordpress122;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                String categoriesAmi = "";
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        if (i < centredinterets.size() - 1) {
                            categoriesAmi = categoriesAmi + categorie.getId() + ",";
                            continue;
                        }
                        categoriesAmi = categoriesAmi + categorie.getId();
                    }
                }
                String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + categoriesAmi + "&orderby=date&order=desc&per_page=5";
                ArticleWordpress[] response = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                List<ArticleWordpress> list = Arrays.asList(response);
                List list2 = list.stream().filter(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) == null).collect(Collectors.toList());
                if (list2.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime latestDate = LocalDateTime.parse(((ArticleWordpress)list2.get(0)).getDate());
                for (Object articleWordpress122 : list2) {
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress122.getDate());
                    if (!currentDate.isAfter(latestDate)) continue;
                    latestDate = currentDate;
                    i = list2.indexOf(articleWordpress122);
                }
                articleWordpress = (ArticleWordpress)list2.get(i);
                String categorieArticle = "";
                articleWordpress122 = categories.iterator();
                while (articleWordpress122.hasNext()) {
                    Categorie categorie = (Categorie)articleWordpress122.next();
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                titre = titre.replace("&#8230;", "...");
                titre = titre.replace("&#8217;", "'").replace("&#8211;", "-");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getCreerpar().equals("email") && ami.getTelephone() != null && !ami.getTelephone().equals("")) {
                    if (ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    }
                } else if (ami.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    } else if (!(ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("") || ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if ((ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) && (ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getUsername());
                    }
                }
                recommandation2.setNumrecommandation(Long.valueOf(4L));
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    @Transactional
    public void RelancerSelectionnerQuatriemeEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            List amisNonRecom;
            Date fin;
            LocalDateTime localDateTime;
            Date debut;
            List amisIdsRecom;
            List<Object> idsAmis = new ArrayList<Long>();
            for (Auteur ami : amis) {
                idsAmis.add(ami.getId());
            }
            if (!(idsAmis.isEmpty() || (amisIdsRecom = this.recommandationRepository.findAmisIdsByDateBetween(debut = Date.from((localDateTime = LocalDateTime.now()).withHour(8).withMinute(33).withSecond(0).atZone(ZoneId.of("GMT")).toInstant()), fin = Date.from(localDateTime.atZone(ZoneId.of("GMT")).toInstant()))).isEmpty() || (idsAmis = idsAmis.stream().filter(a -> !amisIdsRecom.contains(a)).collect(Collectors.toList())).isEmpty() || (amisNonRecom = this.auteurRepository.findAllById(idsAmis)).isEmpty())) {
                this.reSelectionnerQuatriemeenvoi(amisNonRecom);
            }
        }
    }

    @Transactional
    public void RelancerEncoreSelectionnerQuatriemeEnvoi() {
        this.RelancerSelectionnerQuatriemeEnvoi();
    }

    @Transactional
    public void RelancerEncre2SelectionnerQuatriemeEnvoi() {
        try {
            this.RelancerSelectionnerQuatriemeEnvoi();
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de la 4\u00e8me s\u00e9lection de recommandation", e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void S\u00e9lectionnerCinquiemeEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                ArrayList<ArticleWordpress> articleWordpresses = new ArrayList<ArticleWordpress>();
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        idCategorie = categorie.getId();
                        break;
                    }
                    String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + idCategorie + "&per_page=3&orderby=date&order=desc";
                    ArticleWordpress[] articleWordpressArray = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                    articleWordpresses.addAll(Arrays.asList(articleWordpressArray));
                }
                articleWordpresses.removeIf(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) != null);
                if (articleWordpresses.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime localDateTime = LocalDateTime.parse(((ArticleWordpress)articleWordpresses.get(0)).getDate());
                for (ArticleWordpress articleWordpress2 : articleWordpresses) {
                    void var11_17;
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress2.getDate());
                    if (!currentDate.isAfter((ChronoLocalDateTime<?>)var11_17)) continue;
                    LocalDateTime localDateTime2 = currentDate;
                    i = articleWordpresses.indexOf(articleWordpress2);
                }
                articleWordpress = (ArticleWordpress)articleWordpresses.get(i);
                String categorieArticle = "";
                for (Categorie categorie : categories) {
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'").replace("&#8217;", "'");
                titre = titre.replace("&#8230;", "...").replace("&#8211;", "-");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getCreerpar().equals("email") && ami.getTelephone() != null && !ami.getTelephone().equals("")) {
                    if (ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    }
                } else if (ami.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    } else if (!(ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("") || ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if ((ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) && (ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getUsername());
                    }
                }
                recommandation2.setNumrecommandation(Long.valueOf(5L));
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    public void reSelectionnerCinquiemeenvoi(List<Auteur> amis) {
        if (!amis.isEmpty()) {
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                Object articleWordpress122;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                String categoriesAmi = "";
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        if (i < centredinterets.size() - 1) {
                            categoriesAmi = categoriesAmi + categorie.getId() + ",";
                            continue;
                        }
                        categoriesAmi = categoriesAmi + categorie.getId();
                    }
                }
                String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + categoriesAmi + "&orderby=date&order=desc&per_page=5";
                ArticleWordpress[] response = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                List<ArticleWordpress> list = Arrays.asList(response);
                List list2 = list.stream().filter(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) == null).collect(Collectors.toList());
                if (list2.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime latestDate = LocalDateTime.parse(((ArticleWordpress)list2.get(0)).getDate());
                for (Object articleWordpress122 : list2) {
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress122.getDate());
                    if (!currentDate.isAfter(latestDate)) continue;
                    latestDate = currentDate;
                    i = list2.indexOf(articleWordpress122);
                }
                articleWordpress = (ArticleWordpress)list2.get(i);
                String categorieArticle = "";
                articleWordpress122 = categories.iterator();
                while (articleWordpress122.hasNext()) {
                    Categorie categorie = (Categorie)articleWordpress122.next();
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                titre = titre.replace("&#8230;", "...");
                titre = titre.replace("&#8217;", "'").replace("&#8211;", "-");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getCreerpar().equals("email") && ami.getTelephone() != null && !ami.getTelephone().equals("")) {
                    if (ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    }
                } else if (ami.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp());
                        if (ami.getMessagesWhatsapp().booleanValue()) {
                            recommandation2.setEstenvoyerpar("WhatsApp");
                        }
                    } else if (!(ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("") || ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getEmail());
                        if (ami.getMessagesEmail().booleanValue()) {
                            recommandation2.setEstenvoyerpar("email");
                        }
                    } else if ((ami.getNumwhatsapp() == null || ami.getNumwhatsapp().equals("")) && (ami.getEmail() == null || ami.getEmail().equals("") || ami.getEmail().endsWith("@notrecontinent.com"))) {
                        recommandation2.setCompte(ami.getUsername());
                    }
                }
                recommandation2.setNumrecommandation(Long.valueOf(5L));
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    @Transactional
    public void RelancerSelectionnerCinquiemeEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            List amisNonRecom;
            Date fin;
            LocalDateTime localDateTime;
            Date debut;
            List amisIdsRecom;
            List<Object> idsAmis = new ArrayList<Long>();
            for (Auteur ami : amis) {
                idsAmis.add(ami.getId());
            }
            if (!(idsAmis.isEmpty() || (amisIdsRecom = this.recommandationRepository.findAmisIdsByDateBetween(debut = Date.from((localDateTime = LocalDateTime.now()).withHour(8).withMinute(33).withSecond(0).atZone(ZoneId.of("GMT")).toInstant()), fin = Date.from(localDateTime.atZone(ZoneId.of("GMT")).toInstant()))).isEmpty() || (idsAmis = idsAmis.stream().filter(a -> !amisIdsRecom.contains(a)).collect(Collectors.toList())).isEmpty() || (amisNonRecom = this.auteurRepository.findAllById(idsAmis)).isEmpty())) {
                this.reSelectionnerCinquiemeenvoi(amisNonRecom);
            }
        }
    }

    @Transactional
    public void RelancerEncoreSelectionnerCinquiemeEnvoi() {
        this.RelancerSelectionnerQuatriemeEnvoi();
    }

    @Transactional
    public void RelancerEncre2SelectionnerCinquiemeEnvoi() {
        try {
            this.RelancerSelectionnerQuatriemeEnvoi();
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de la 5\u00e8me s\u00e9lection de recommandation", e.getMessage());
        }
    }
}

