/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.notrecontinent.webapi.LesDTOs.ArticlesAdminDto;
import com.notrecontinent.webapi.LesDTOs.AuteurAdminDto;
import com.notrecontinent.webapi.LesDTOs.AuteurPwdDTO;
import com.notrecontinent.webapi.LesDTOs.RecommandationAdminDTO;
import com.notrecontinent.webapi.LesDTOs.StatistiquesArticle;
import com.notrecontinent.webapi.dto.DashbordStats;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Bugs;
import com.notrecontinent.webapi.entities.Connexion;
import com.notrecontinent.webapi.response.UserInfoResponse;
import com.notrecontinent.webapi.services.AdminService;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/speaky"})
@CrossOrigin(value={"*"})
public class AdminController {
    @Autowired
    private AdminService adminService;

    @GetMapping(value={"/Admin/connexion"})
    public ResponseEntity<List<Connexion>> getAllConnexion() throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration de toutes les connexions par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAllConnexion();
    }

    @GetMapping(value={"/Admin/deconnexion/{idconnexion}"})
    public String DeconnecterAdmin(@PathVariable(value="idconnexion") Long idconnexion) throws ParseException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("D\u00e9connexion de l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.Deconnexion(idconnexion);
    }

    @GetMapping(value={"/Admin/articles"})
    public ResponseEntity<List<ArticlesAdminDto>> getAllArticles() throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration de tous les articles par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAllArticles();
    }

    @PutMapping(value={"/Admin/desactiverarticle"})
    public String DeactivateArticle(@RequestParam(value="id") String id) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("D\u00e9sactivation d'un article par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.DeactivateArticle(id);
    }

    @PutMapping(value={"/Admin/desactiverarticles"})
    public String DeactivateArticles(@Validated @RequestBody List<Long> ids) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("D\u00e9sactivation de plusieurs articles par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.DeactivateArticles(ids);
    }

    @PutMapping(value={"/Admin/reactiverarticle"})
    public String ReactivateArticle(@RequestParam(value="id") String id) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9activation d'un article par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.ReactivateArticle(id);
    }

    @PutMapping(value={"/Admin/reactiverarticles"})
    public String ReactivateArticles(@Validated @RequestBody List<Long> ids) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9activation de plusieurs articles par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.ReactivateArticles(ids);
    }

    @GetMapping(value={"/Admin/auteurs"})
    public ResponseEntity<List<AuteurAdminDto>> getAllAuteur() throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration de tous les comptes par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAllAuteur();
    }

    @PostMapping(value={"/Admin/auteur"})
    public Auteur CreateAuteur(@Validated @RequestBody Auteur auteur) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Cr\u00e9ation d'un compte contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.CreateAuteur(auteur);
    }

    @PutMapping(value={"/Admin/pwdauteur"})
    public String UpdatePasswordAuteur(@RequestParam(value="id") String id, @RequestParam(value="newpwd") String newpwd) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Modification du mot de passe d'un compte contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.UpdatePasswordAuteur(id, newpwd);
    }

    @PutMapping(value={"/Admin/bloquerauteur"})
    public String BloquerAuteur(@RequestParam(value="id") String id) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("D\u00e9sactivation d'un compte contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.BloquerAuteur(id);
    }

    @PutMapping(value={"/Admin/reactiverauteur"})
    public String ResactiverAuteur(@RequestParam(value="id") String id) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9activation d'un compte contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.ReactiverAuteur(id);
    }

    @PutMapping(value={"/Admin/bloquerauteurs"})
    public String BloquerAuteurs(@Validated @RequestBody List<Long> ids) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("D\u00e9sactivation de plusieurs comptes contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.BloquerAuteurs(ids);
    }

    @PutMapping(value={"/Admin/reactiverauteurs"})
    public String ResactiverAuteurs(@Validated @RequestBody List<Long> ids) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9activation de plusieurs comptes contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.ReactiverAuteurs(ids);
    }

    @PostMapping(value={"/Admin/SeConnecterAuCompteAuteur"})
    public UserInfoResponse SeConnecterAuCompteAuteur(@RequestParam(value="username") String username, @RequestParam(value="pwd") String pwd) {
        return this.adminService.SeConnecterAuCompteAuteur(username, pwd);
    }

    @GetMapping(value={"/Admin/getAllAuteurPwdDtos"})
    public ResponseEntity<List<AuteurPwdDTO>> getAllAuteurPwdDtos() throws JsonProcessingException {
        return this.adminService.getAllAuteurPwdDtos();
    }

    @GetMapping(value={"/Admin/dashboard"})
    public ResponseEntity<List<DashbordStats>> getAdminDashboardStats() throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des donn\u00e9es du tableau de bord admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAdminDashboardStats();
    }

    @GetMapping(value={"/Admin/statistiques"})
    public ResponseEntity<List<StatistiquesArticle>> getAdminStatistiques() throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration de toutes les statistiques par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAdminStatistiques();
    }

    @GetMapping(value={"/Admin/bugs"})
    public ResponseEntity<List<Bugs>> getAllBugs() throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration de tous les bugs par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAllBugs();
    }

    @PostMapping(value={"/Admin/recommandations"})
    public ResponseEntity<RecommandationAdminDTO> getAllRecommandations(@RequestParam(defaultValue="0") String pageNumber) throws JsonProcessingException {
        return this.adminService.getAllRecommandations(Integer.parseInt(pageNumber));
    }
}

