/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.LesDTOs.NotificationSmsStatus;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.NotificationSms;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.NotificationSmsRepository;
import com.notrecontinent.webapi.services.SmsService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NotificationSmsService {
    @Autowired
    private NotificationSmsRepository notificationSmsRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private SmsService smsService;

    @Transactional
    @Scheduled(cron="10 45 10 * * *", zone="GMT")
    public void SelectionnerNotificationsSms() {
        LocalDateTime currentDate = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime datedebut = currentDate.withYear(2024).withMonth(2).withDayOfMonth(10).withHour(0).withMinute(0).withSecond(0);
        Date datededebut = Date.from(datedebut.atZone(ZoneId.of("GMT")).toInstant());
        List amisSms = this.auteurRepository.findAmiSms(datededebut);
        if (!amisSms.isEmpty() && !(amisSms = amisSms.stream().filter(a -> a.getUsername().startsWith("221") && (a.getEmail().equals("") || a.getEmail() == null || a.getEmail().endsWith("@notrecontinent.com"))).collect(Collectors.toList())).isEmpty()) {
            ArrayList subLists = new ArrayList();
            int size = amisSms.size();
            int quotient = size / 5;
            int remainder = size % 5;
            int index = 0;
            for (int i = 0; i < 5; ++i) {
                int chunk = quotient + (i < remainder ? 1 : 0);
                List subList = amisSms.subList(index, index + chunk);
                subLists.add(subList);
                index += chunk;
            }
            if (!subLists.isEmpty()) {
                NotificationSms notificationSms;
                ArrayList<NotificationSms> notificationSmsList = new ArrayList<NotificationSms>();
                if (!((List)subLists.get(0)).isEmpty()) {
                    for (Auteur ami : (List)subLists.get(0)) {
                        notificationSms = new NotificationSms();
                        notificationSms.setAmiid(ami.getId());
                        notificationSms.setEstenvoyer(Boolean.valueOf(false));
                        notificationSms.setNomami(ami.getFirst_name());
                        notificationSms.setNumero(ami.getUsername());
                        notificationSms.setLotenvoi("premier envoi");
                        notificationSmsList.add(notificationSms);
                    }
                }
                if (!((List)subLists.get(1)).isEmpty()) {
                    for (Auteur ami : (List)subLists.get(1)) {
                        notificationSms = new NotificationSms();
                        notificationSms.setAmiid(ami.getId());
                        notificationSms.setEstenvoyer(Boolean.valueOf(false));
                        notificationSms.setNomami(ami.getFirst_name());
                        notificationSms.setNumero(ami.getUsername());
                        notificationSms.setLotenvoi("second envoi");
                        notificationSmsList.add(notificationSms);
                    }
                }
                if (!((List)subLists.get(2)).isEmpty()) {
                    for (Auteur ami : (List)subLists.get(2)) {
                        notificationSms = new NotificationSms();
                        notificationSms.setAmiid(ami.getId());
                        notificationSms.setEstenvoyer(Boolean.valueOf(false));
                        notificationSms.setNomami(ami.getFirst_name());
                        notificationSms.setNumero(ami.getUsername());
                        notificationSms.setLotenvoi("troisi\u00e8me envoi");
                        notificationSmsList.add(notificationSms);
                    }
                }
                if (!((List)subLists.get(3)).isEmpty()) {
                    for (Auteur ami : (List)subLists.get(3)) {
                        notificationSms = new NotificationSms();
                        notificationSms.setAmiid(ami.getId());
                        notificationSms.setEstenvoyer(Boolean.valueOf(false));
                        notificationSms.setNomami(ami.getFirst_name());
                        notificationSms.setNumero(ami.getUsername());
                        notificationSms.setLotenvoi("quatri\u00e8me envoi");
                        notificationSmsList.add(notificationSms);
                    }
                }
                if (!((List)subLists.get(4)).isEmpty()) {
                    for (Auteur ami : (List)subLists.get(4)) {
                        notificationSms = new NotificationSms();
                        notificationSms.setAmiid(ami.getId());
                        notificationSms.setEstenvoyer(Boolean.valueOf(false));
                        notificationSms.setNomami(ami.getFirst_name());
                        notificationSms.setNumero(ami.getUsername());
                        notificationSms.setLotenvoi("cinqui\u00e8me envoi");
                        notificationSmsList.add(notificationSms);
                    }
                }
                this.notificationSmsRepository.saveAll(notificationSmsList);
            }
        }
    }

    @Transactional
    @Scheduled(cron="20 0 * * * *", zone="GMT")
    public void EnvoyerNotificationAmiSms() {
        List notificationSmsList;
        LocalDateTime currentDate = LocalDateTime.now(ZoneId.of("GMT"));
        int hour = currentDate.getHour();
        String lotenvoi = "";
        switch (hour) {
            case 11: {
                lotenvoi = "premier envoi";
                break;
            }
            case 12: {
                lotenvoi = "second envoi";
                break;
            }
            case 13: {
                lotenvoi = "troisi\u00e8me envoi";
                break;
            }
            case 14: {
                lotenvoi = "quatri\u00e8me envoi";
                break;
            }
            case 15: {
                lotenvoi = "cinqui\u00e8me envoi";
                break;
            }
            default: {
                System.out.println("Aucun envoi de sms \u00e0 faire");
            }
        }
        if (!lotenvoi.equals("") && !(notificationSmsList = this.notificationSmsRepository.findByEstenvoyerAndLotenvoi(Boolean.valueOf(false), lotenvoi)).isEmpty()) {
            for (NotificationSms notificationSms : notificationSmsList) {
                NotificationSmsStatus notificationSmsStatus = this.smsService.SendNotificationAmi(notificationSms.getNumero(), notificationSms.getNomami());
                if (!notificationSmsStatus.getMessage().equals("success") || !notificationSmsStatus.getCode().equals(200L)) continue;
                notificationSms.setStatus(notificationSmsStatus.getStatus());
                notificationSms.setSms_id(notificationSmsStatus.getSms_id());
                notificationSms.setDateenvoi(new Date());
                notificationSms.setEstenvoyer(Boolean.valueOf(true));
            }
            this.notificationSmsRepository.saveAll((Iterable)notificationSmsList);
        }
    }

    public void VerifierStatusNotification() {
    }
}

