/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.Recommandation;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PointsAmiService {
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private AuteurRepository auteurRepository;

    @Transactional
    public void getpointsFromOldRecom() {
        List recommandations = this.recommandationRepository.findByEstcliquer(Boolean.valueOf(true));
        if (!recommandations.isEmpty()) {
            for (Recommandation r : recommandations) {
                r.setDateClick(r.getDateModification());
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                String mois = dateFormat.format(r.getDateModification());
                Auteur ami = (Auteur)this.auteurRepository.findById((Object)r.getAuteurid()).get();
                PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, r.getAuteurid());
                if (pointsAmi == null) {
                    PointsAmi p = new PointsAmi();
                    p.setNbArticlesLus(Long.valueOf(1L));
                    p.setNbPointsArticlesLus(Long.valueOf(2L));
                    p.setNbPointsMois(Long.valueOf(2L));
                    p.setAmiId(r.getAuteurid());
                    p.setMois(mois);
                    ami.setTotalPointsCumules(Long.valueOf(2L));
                    this.pointsAmiRepository.save((Object)p);
                } else {
                    pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsMois() + 2L));
                    pointsAmi.setNbPointsArticlesLus(Long.valueOf(pointsAmi.getNbPointsArticlesLus() + 2L));
                    pointsAmi.setNbArticlesLus(Long.valueOf(pointsAmi.getNbArticlesLus() + 1L));
                    ami.setTotalPointsCumules(Long.valueOf(ami.getTotalPointsCumules() + 2L));
                    this.pointsAmiRepository.save((Object)pointsAmi);
                }
                this.auteurRepository.save((Object)ami);
            }
            this.recommandationRepository.saveAll((Iterable)recommandations);
        }
    }

    @Transactional
    public void updatetypecreationcompte() {
        List auteurs = this.auteurRepository.findAll();
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                if (this.isNumeric(auteur.getUsername())) {
                    auteur.setCreerpar("t\u00e9l\u00e9phone");
                    continue;
                }
                if (this.isNumeric(auteur.getUsername())) continue;
                auteur.setCreerpar("email");
            }
        }
    }

    public boolean isNumeric(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

