/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.dto.AuthToken;
import com.notrecontinent.webapi.dto.CompteWordpress;
import com.notrecontinent.webapi.dto.ResponseAuthToken;
import com.notrecontinent.webapi.dto.SensSMS;
import com.notrecontinent.webapi.dto.VerifCode;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.services.AuteurService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import javax.mail.MessagingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SmsService {
    @Autowired
    private AuteurService auteurService;
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private RestTemplate restTemplate;
    String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    public ResponseAuthToken getAuthToken() {
        AuthToken authToken = new AuthToken("XorguiNC", "Tonti@Diatta9??");
        ResponseAuthToken responseAuthToken = (ResponseAuthToken)this.restTemplate.postForObject("https://sms.tinsight.tech/auth2/get_token_auth/", (Object)authToken, ResponseAuthToken.class, new Object[0]);
        return responseAuthToken;
    }

    public ResponseEntity<String> SendValidationCode(String numero, String pays) throws JsonProcessingException {
        Boolean compteexiste = this.auteurService.verifUsername(numero, pays);
        if (compteexiste.booleanValue()) {
            return null;
        }
        ResponseAuthToken responseAuthToken = this.getAuthToken();
        String token = responseAuthToken.getToken();
        String smsCode = this.SendSMSCode(numero, token);
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)smsCode);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)smsCode);
    }

    public String SendSMSCode(String numero, String authToken) {
        HttpHeaders headers = new HttpHeaders();
        String authHeader = "Token " + authToken;
        headers.set("Authorization", authHeader);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("phone_number", numero);
        HttpEntity requestEntity = new HttpEntity(map, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange("https://sms.tinsight.tech/apiv2/smscode/", HttpMethod.POST, requestEntity, String.class, new Object[0]);
        System.out.print("r\u00e9ponse : ");
        System.out.println(((String)response.getBody()).toString());
        return "code envoy\u00e9";
    }

    public ResponseEntity<Auteur> VerifierSmsCodeEtSaveAuteur(Auteur auteur, String code) throws MessagingException, IOException {
        Auteur auteur1 = new Auteur();
        String authToken = this.getAuthToken().getToken();
        VerifCode verifCode = this.VerifSMSCode(auteur.getUsername(), code, authToken);
        HttpHeaders headers = new HttpHeaders();
        String authHeader = "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes());
        headers.set("Authorization", authHeader);
        CompteWordpress compteWordpress = new CompteWordpress();
        compteWordpress.setUsername(auteur.getUsername());
        compteWordpress.setPassword(auteur.getPassword());
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        String dateString = format.format(new Date());
        compteWordpress.setEmail("PL-" + dateString + "-" + auteur.getEmail());
        System.out.println(compteWordpress.getEmail());
        HttpEntity compteRequestEntity = new HttpEntity((Object)compteWordpress, (MultiValueMap)headers);
        String response = (String)this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/users", HttpMethod.POST, compteRequestEntity, String.class, new Object[0]).getBody();
        Long id = Long.valueOf(response.split(",")[0].split(":")[1]);
        auteur.setWordpressID(id);
        auteur1 = this.auteurService.SaveAuteur(auteur);
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)auteur1);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headerss = new HttpHeaders();
        headerss.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headerss)).body((Object)auteur1);
    }

    public VerifCode VerifSMSCode(String numero, String code, String authToken) {
        HttpHeaders headers = new HttpHeaders();
        String authHeader = "Token " + authToken;
        headers.set("Authorization", authHeader);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("phone_number", numero);
        map.put("code", code);
        HttpEntity requestEntity = new HttpEntity(map, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange("https://sms.tinsight.tech/apiv2/verify_code/", HttpMethod.POST, requestEntity, VerifCode.class, new Object[0]);
        System.out.print("r\u00e9ponse : ");
        System.out.println(response.getBody());
        return (VerifCode)response.getBody();
    }

    public String EnvoyerSmsValidationArticle(String numero, String lastname, String civilite, String lien) {
        SensSMS sms = new SensSMS();
        ResponseAuthToken responseAuthToken = this.getAuthToken();
        if (responseAuthToken.getToken() != null) {
            String authToken = responseAuthToken.getToken();
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "Token " + authToken;
            headers.set("Authorization", authHeader);
            String salutation = "";
            LocalTime localTime = LocalTime.now();
            int currentHour = localTime.getHour();
            salutation = currentHour <= 12 ? "Bonjour " : "Bonsoir ";
            String civiliteAbregee = "";
            if (civilite.equals("Monsieur")) {
                civiliteAbregee = "Mr ";
            } else if (civilite.equals("Madame")) {
                civiliteAbregee = "Mme ";
            } else if (civilite.equals("Mademoiselle")) {
                civiliteAbregee = "Mlle ";
            }
            String message = salutation + civiliteAbregee + lastname + ", votre article a \u00e9t\u00e9 mis en ligne avec succ\u00e8s.\n";
            message = message + lien + "\n";
            message = message + "A tr\u00e8s bient\u00f4t";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", numero);
            map.put("message", message);
            HttpEntity requestEntity = new HttpEntity(map, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange("https://sms.tinsight.tech/apiv2/sms/", HttpMethod.POST, requestEntity, SensSMS.class, new Object[0]);
            sms = (SensSMS)response.getBody();
        }
        return sms.getMessage();
    }
}

