/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.Recommandation;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationAunAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import com.notrecontinent.webapi.services.BugsCronService;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PointsAmiService {
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Autowired
    private RecommandationAunAmiRepository recommandationAunAmiRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private BugsCronService bugsCronService;

    @Transactional
    public void getpointsFromOldRecom() {
        List recommandations = this.recommandationRepository.findByEstcliquer(Boolean.valueOf(true));
        if (!recommandations.isEmpty()) {
            for (Recommandation r : recommandations) {
                r.setDateClick(r.getDateModification());
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                String mois = dateFormat.format(r.getDateModification());
                Auteur ami = (Auteur)this.auteurRepository.findById((Object)r.getAuteurid()).get();
                PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, r.getAuteurid());
                if (pointsAmi == null) {
                    PointsAmi p = new PointsAmi();
                    p.setNbArticlesLus(Long.valueOf(1L));
                    p.setNbPointsArticlesLus(Long.valueOf(2L));
                    p.setNbPointsMois(Long.valueOf(2L));
                    p.setAmiId(r.getAuteurid());
                    p.setMois(mois);
                    ami.setTotalPointsCumules(Long.valueOf(2L));
                    this.pointsAmiRepository.save((Object)p);
                } else {
                    pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsMois() + 2L));
                    pointsAmi.setNbPointsArticlesLus(Long.valueOf(pointsAmi.getNbPointsArticlesLus() + 2L));
                    pointsAmi.setNbArticlesLus(Long.valueOf(pointsAmi.getNbArticlesLus() + 1L));
                    ami.setTotalPointsCumules(Long.valueOf(ami.getTotalPointsCumules() + 2L));
                    this.pointsAmiRepository.save((Object)pointsAmi);
                }
                this.auteurRepository.save((Object)ami);
            }
            this.recommandationRepository.saveAll((Iterable)recommandations);
        }
    }

    @Scheduled(cron="15 47 11 * * *", zone="GMT")
    @Transactional
    public void updatePointsCumules() {
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                for (Auteur ami : amis) {
                    List pointsAmis = this.pointsAmiRepository.findByAmiId(ami.getId());
                    if (pointsAmis.isEmpty()) continue;
                    Long pointscumules = 0L;
                    for (PointsAmi p : pointsAmis) {
                        pointscumules = pointscumules + p.getNbPointsMois();
                    }
                    ami.setTotalPointsCumules(pointscumules);
                }
                this.auteurRepository.saveAll((Iterable)amis);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points cumul\u00e9s des comptes amis", e.getMessage());
        }
    }

    @Scheduled(cron="30 0 4 1 * *", zone="GMT")
    @Transactional
    public void updatearticleslus() {
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                for (Auteur ami : amis) {
                    List recommandationList;
                    List pointsAmis = this.pointsAmiRepository.findByAmiId(ami.getId());
                    if (pointsAmis.isEmpty() || (recommandationList = this.recommandationRepository.findByEstcliquerAndAuteurid(Boolean.valueOf(true), ami.getId())).isEmpty()) continue;
                    for (PointsAmi p : pointsAmis) {
                        String mois = p.getMois();
                        List recommandations = recommandationList.stream().filter(r -> mois.equals(dateFormat.format(r.getDateClick()))).collect(Collectors.toList());
                        if (recommandations.isEmpty()) continue;
                        p.setNbArticlesLus(Long.valueOf(recommandations.size()));
                        p.setNbPointsArticlesLus(Long.valueOf(2L * p.getNbArticlesLus()));
                        p.setNbPointsMois(Long.valueOf(p.getNbPointsArticlesLus() + p.getNbPointsRecommandations() + p.getNbPointsMissions()));
                    }
                    this.pointsAmiRepository.saveAll((Iterable)pointsAmis);
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points des articles lus des comptes amis", e.getMessage());
        }
    }

    @Transactional
    @Scheduled(cron="15 0 4 1 * *", zone="GMT")
    public void updaterecommandationsaunami() {
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                for (Auteur ami : amis) {
                    List recommandationAunAmisList;
                    List pointsAmis = this.pointsAmiRepository.findByAmiId(ami.getId());
                    if (pointsAmis.isEmpty() || (recommandationAunAmisList = this.recommandationAunAmiRepository.findByAmiID(ami.getId())).isEmpty()) continue;
                    for (PointsAmi p : pointsAmis) {
                        String mois = p.getMois();
                        List recommandationAunAmis = recommandationAunAmisList.stream().filter(r -> mois.equals(dateFormat.format(r.getDateCreation()))).collect(Collectors.toList());
                        if (recommandationAunAmis.isEmpty()) continue;
                        p.setNbRecommandations(Long.valueOf(recommandationAunAmis.size()));
                        p.setNbPointsRecommandations(Long.valueOf(5L * p.getNbRecommandations()));
                        p.setNbPointsMois(Long.valueOf(p.getNbPointsArticlesLus() + p.getNbPointsRecommandations() + p.getNbPointsMissions()));
                    }
                    this.pointsAmiRepository.saveAll((Iterable)pointsAmis);
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points 'Recommandations \u00e0 un ami' des comptes amis", e.getMessage());
        }
    }
}

